<?php $__env->startSection('icerik'); ?>

    <div class="pagetitle">
        <h1>Turlar</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/">Site</a></li>
                <li class="breadcrumb-item active">Turlar</li>
            </ol>
        </nav>
    </div><!-- End Page Title -->


    <section class="section dashboard">
        <div class="row">
            <div class="col-lg-12">
                <div class="alert-info alert">
                    <a href="turlar#turlist">Önceden eklenmiş turları görmek için buraya tıklayın</a>
                </div>

                <div class="card">
                    <div class="card-header"><i class="bx bx-plus-circle"></i> Tur Ekle</div>
                    <div class="card-body">

                        <form action="turekle" class="arala" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="baslik">Tur Adı</label>
                                        <input required type="text" class="form-control" name="baslik">
                                    </div>

                                    <div class="form-group">
                                        <label for="katid">Tur Kategorisi</label>
                                        <select name="katid" class="form-select">
                                            <option>Kategori Seçiniz</option>
                                            <?php $__currentLoopData = $kat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($item->id); ?>"><?php echo e($item->turkat); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="form-group">
                                        <label for="star">Öne Çıkan Özellik</label>
                                        <input required type="text" class="form-control" name="star" value="Otelden Alınır">
                                    </div>

                                    <div class="form-group">
                                        <label for="baslama">Başlama Saati</label>
                                        <input required type="text" class="form-control" name="baslama" value="09:00">
                                    </div>

                                    <div class="form-group">
                                        <label for="bitis">Bitiş Saati</label>
                                        <input required type="text" class="form-control" name="bitis" value="20:00">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="yetiskin">Yetişkin Fiyat</label>
                                        <input required type="text" class="form-control" name="yetiskin">
                                    </div>

                                    <div class="form-group">
                                        <label for="bcocuk">Büyük Çocuk Fiyat</label>
                                        <input required type="text" class="form-control" name="bcocuk">
                                    </div>

                                    <div class="form-group">
                                        <label for="kcocuk">Küçük Çocuk Fiyat</label>
                                        <input required type="text" class="form-control" name="kcocuk">
                                    </div>

                                    <div class="form-group">
                                        <label for="bebek">Bebek Fiyat</label>
                                        <input required type="text" class="form-control" name="bebek">
                                    </div>

                                    <div class="form-group">
                                        <label for="img">Kapak Fotoğrafı</label>
                                        <input required type="file" accept="image/*" name="img" class="form-control">
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                Tur Kısa Tanım
                                <textarea name="turkisatanim" class="form-control" id="" cols="30" rows="5" placeholder="2 paragraf tur kısa tanım"></textarea>
                            </div>

                            <div class="form-group">
                                <label for="program">Tur Tanıtımı</label>
                                <div class="editor-container">
                                    <textarea id="editor" name="program"></textarea>
                                </div>
                                <script>
                                    ClassicEditor
                                        .create(document.getElementById('editor'))
                                        .then(editor => {
                                            console.log('Editor was initialized');
                                        })
                                        .catch(error => {
                                            console.error(error);
                                        });
                                </script>
                            </div>

                            <button class="btn btn-success"><i class="bx bxs-save"></i> Tur Ekle</button>
                        </form>


                    </div>
                </div>
            </div>

            <div class="col-lg-12">
                <a name="turlist"></a>
                <div class="card">
                    <div class="card-header"><i class="bx bx-plus-circle"></i> Turlar</div>
                    <div class="card-body">
                        <table class="table table-hover">
                            <tr class="fw-bold">
                                <td>#</td>
                                <td>Baslık</td>
                                <td>Kategori</td>
                                <td>Özellik</td>
                                <td>Saatler</td>
                                <td>Yetişkin</td>
                                <td>B.Çocuk</td>
                                <td>K.Çocuk</td>
                                <td>Bebek</td>
                                <td>Düzenle</td>
                                <td>Sil</td>
                            </tr>
                            <?php $__currentLoopData = $tur; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <tr>
                                    <td><?php echo e($item->turlar_id); ?></td>
                                    <td><?php echo e($item->baslik); ?></td>
                                    <td><?php echo e($item->turkat); ?></td>
                                    <td><?php echo e($item->star); ?></td>
                                    <td><?php echo e($item->baslama); ?> - <?php echo e($item->bitis); ?></td>
                                    <td><?php echo e($item->yetiskin); ?></td>
                                    <td><?php echo e($item->bcocuk); ?></td>
                                    <td><?php echo e($item->kcocuk); ?></td>
                                    <td><?php echo e($item->bebek); ?></td>
                                    <td><a href="turduzenle?id=<?php echo e($item->turlar_id); ?>" class="btn btn-sm btn-primary">Düzenle</a></td>
                                    <td><div onclick="silmi('tursil?id=<?php echo e($item->turlar_id); ?>')"  class="btn btn-sm btn-danger">Sil</div></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          </table>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <style>
        .arala * {
            margin-bottom: 5px;
            margin-top: 5px;
            clear: both
        }

        .arabafoto { border-radius: 5px; border: solid 0.5px darkgray; padding: 3px}
    </style>
    <style>
        /* Set the height of the textarea to 30% of the viewport height */
        #editor {
            height: 30vh;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('title','Turlar'); ?>

<?php echo $__env->make('panel.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ucretsizscript/transferpro2.ucretsizscript.net/resources/views/admin/turlar.blade.php ENDPATH**/ ?>