<!DOCTYPE html>
<html>
<head>
    <title>Google Haritalar Yol Çizme</title>
    <style>
        #map {
            height: 400px;
            width: 100%;
        }
        body { margin: 0; padding: 0; }
    </style>
</head>
<body>

<div class="map" id="map" data-p1="<?php echo e($transfer->origin); ?>" data-p2="<?php echo e($transfer->destination); ?>" style="background-size: 100%; background-repeat: no-repeat;"></div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://maps.googleapis.com/maps/api/js?key=<?php echo e($ayar['googlemaps']); ?>&libraries=geometry"></script>
<script>
    $(document).ready(function() {
        var p1 = $("#map").data("p1").split(",");
        var p2 = $("#map").data("p2").split(",");

        var mapOptions = {
            center: { lat: parseFloat(p1[0]), lng: parseFloat(p1[1]) },
            zoom: 8
        };

        var map = new google.maps.Map(document.getElementById('map'), mapOptions);

        var directionsService = new google.maps.DirectionsService();
        var directionsDisplay = new google.maps.DirectionsRenderer();

        directionsDisplay.setMap(map);

        var request = {
            origin: new google.maps.LatLng(parseFloat(p1[0]), parseFloat(p1[1])),
            destination: new google.maps.LatLng(parseFloat(p2[0]), parseFloat(p2[1])),
            travelMode: google.maps.TravelMode.DRIVING
        };

        directionsService.route(request, function(response, status) {
            if (status == google.maps.DirectionsStatus.OK) {
                directionsDisplay.setDirections(response);
            }
        });
    });
</script>
</body>
</html>
<?php /**PATH C:\laragon\www\transferpro2\resources\views/map.blade.php ENDPATH**/ ?>