<?php use Illuminate\Support\Carbon; ?>

<?php $__env->startSection('icerik'); ?>

    <section id="section-hero" aria-label="section" class=" mt-80 sm-mt-0"
             style="background-size: 100%; background-repeat: no-repeat;">

        <div class="container" style="background-size: 100%; background-repeat: no-repeat;">

            <div class="row align-items-center pt-3" style="background-size: 100%; background-repeat: no-repeat;">
                <h3>Rezervasyon Onayla</h3>
                <div class="col-lg-12" style="background-size: 100%; background-repeat: no-repeat;">

                    <div class="p-4 rounded-5 shadow-2-strong bgcustom" data-bgcolor="#ffffff"
                         style="background-color: rgb(255, 255, 255); background-size: 100%; background-repeat: no-repeat;">


                        <form name="contactForm" id="contact_form" method="post"
                              action="/paytr?sorgu=<?php echo e($request->sorgu); ?>&tip=transfer">
                            <input type="hidden" name="arac" value="<?php echo e($request->arac); ?>">
                            <?php echo csrf_field(); ?>
                            <div id="step-1" class="row" style="background-size: 100%; background-repeat: no-repeat;">
                                <div class="col-lg-5 mb30" style="background-size: 100%; background-repeat: no-repeat;">
                                    <h5><i class="fa fa-arrow-circle-o-up"></i> Transfer Şeklini Seçiniz</h5>

                                    <div class="de_form de_radio row g-3"
                                         style="background-size: 100%; background-repeat: no-repeat;">
                                        <div class="radio-img col-lg-6 col-sm-3 col-6"
                                             style="background-size: 100%; background-repeat: no-repeat;">
                                            <input id="radio-1a" name="miktar" type="radio"
                                                   value="Tek|<?php echo e((($transfer->distance*$arac->km)+$arac->acilis)); ?>"
                                                   checked="checked" class="secimx">
                                            <label for="radio-1a">
                                                <img src="/images/tekyon.png"
                                                     style="height: 64px; width: auto!important;" alt="">
                                                Tek Yön
                                                <br>
                                                <?php if(session()->get('pb')==$ayar['pb']): ?>
                                                    <span><?php echo e(number_format(($miktar),2)); ?>  <?php echo e($ayar['pb']); ?></span>
                                                <?php else: ?>
                                                    <span><?php echo e(number_format((($transfer->distance * $arac->km) + $arac->acilis) * $doviz[$ayar['pb']] / $doviz[session()->get('pb')], 2)); ?>

                                                        <?php echo e(session()->get('pb')); ?></span>
                                                <?php endif; ?>
                                            </label>

                                        </div>

                                        <div class="radio-img col-lg-6 col-sm-3 col-6"
                                             style="background-size: 100%; background-repeat: no-repeat;">
                                            <input id="radio-1b" name="miktar" type="radio"
                                                   value="Çift|<?php echo e(($arac->acilis+(($arac->acilis)+($transfer->distance*$arac->km*1.75)))); ?>"
                                                   class="secimx">
                                            <label for="radio-1b">
                                                <img src="/images/ciftyon.png" alt=""
                                                     style="height: 64px; width: auto!important;">
                                                Çift Yön
                                                <br>


                                                <?php if(session()->get('pb')==$ayar['pb']): ?>
                                                    <span><?php echo e(number_format(($miktar*1.75),2)); ?>  <?php echo e($ayar['pb']); ?></span>
                                                <?php else: ?>
                                                    <span><?php echo e(number_format((($transfer->distance * $arac->km) + $arac->acilis) * $doviz[$ayar['pb']] / $doviz[session()->get('pb')]*1.75, 2)); ?>

                                                        <?php echo e(session()->get('pb')); ?></span>
                                                <?php endif; ?>


                                            </label>
                                        </div>


                                    </div>
                                </div>

                                <div class="col-lg-7" style="background-size: 100%; background-repeat: no-repeat;">
                                    <div class="row" style="background-size: 100%; background-repeat: no-repeat;">
                                        <div class="col-lg-6 mb20"
                                             style="background-size: 100%; background-repeat: no-repeat;">
                                            <h5><i class="fa fa-map-marker"></i> Alınma Noktası</h5>
                                            <input type="text" name="alinmanoktasi"
                                                   placeholder="Enter your pickup location" readonly
                                                   value="<?php echo e($transfer->alinmanoktasi); ?>" id="autocomplete"
                                                   autocomplete="off" class="form-control pac-target-input">

                                            <div class="jls-address-preview jls-address-preview--hidden"
                                                 style="background-size: 100%; background-repeat: no-repeat;">
                                                <div class="jls-address-preview__header"
                                                     style="background-size: 100%; background-repeat: no-repeat;">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-lg-6 mb20"
                                             style="background-size: 100%; background-repeat: no-repeat;">
                                            <h5><i class="fa fa-map-marker"></i> Bırakılma Noktası</h5>
                                            <input type="text" name="birakilmanoktasi"
                                                   value="<?php echo e($transfer->birakilmanoktasi); ?>" readonly
                                                   placeholder="Enter your dropoff location" id="autocomplete2"
                                                   autocomplete="off" class="form-control pac-target-input">

                                            <div class="jls-address-preview jls-address-preview--hidden"
                                                 style="background-size: 100%; background-repeat: no-repeat;">
                                                <div class="jls-address-preview__header"
                                                     style="background-size: 100%; background-repeat: no-repeat;">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-lg-6 mb20"
                                             style="background-size: 100%; background-repeat: no-repeat;">
                                            <h5><i class="fa fa-calendar-check-o"></i> Alınma Tarihi</h5>
                                            <div class="date-time-field"
                                                 style="background-size: 100%; background-repeat: no-repeat;">
                                                <input type="text" id="date-picker" name="alinmatarihvesaati"
                                                       style="width: 100%" class="form-control" readonly
                                                       value="<?php echo e(Carbon::createFromDate($transfer->alinmatarihi)->format('d/m/Y H:i')); ?>">

                                            </div>
                                        </div>

                                        <div class="col-lg-6 mb20"
                                             style="background-size: 100%; background-repeat: no-repeat;">
                                            <h5><i class="fa fa-calendar-check-o"></i> Bırakılma tarih ve saati</h5>
                                            <div class="date-time-field"
                                                 style="background-size: 100%; background-repeat: no-repeat;">
                                                <input type="text" id="date-picker-2" name="birakilmatarihi"
                                                       value="<?php echo e(Carbon::createFromDate($transfer->alinmatarihi)->format('d/m/Y H:i')); ?>"
                                                       class="form-control" style="width: 100%" readonly>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                <div class="col-lg-12">

                                    <h4>Satın alabileceğiniz ek hizmetler</h4>
                                    <style>
                                        .ekhizmet li input {
                                            margin-left: 20px;
                                        }
                                    </style>

                                    <ul style="list-style: none" class="ekhizmet">
                                        <?php $__currentLoopData = $ekhizmet; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                            <?php if(session()->get('pb')==$ayar['pb']): ?>
                                                <li class="mb-2">
                                                    <label for="v<?php echo e($item->id); ?>"><input type="checkbox"
                                                                                         style="appearance: auto!important;"
                                                                                         id="v<?php echo e($item->id); ?>"
                                                                                         name="ekhizmet[]"
                                                                                         value="<?php echo e($item->id); ?>"> <?php echo e($item->hizmet); ?>

                                                        <b><?php echo e($item->ucret); ?> <?php echo e($ayar['pb']); ?></b>
                                                    </label>

                                                </li>
                                            <?php else: ?>

                                                <li class="mb-2">
                                                    <label for="v<?php echo e($item->id); ?>"><input type="checkbox"
                                                                                         style="appearance: auto!important;"
                                                                                         id="v<?php echo e($item->id); ?>"
                                                                                         name="ekhizmet[]"
                                                                                         value="<?php echo e($item->id); ?>"> <?php echo e($item->hizmet); ?>

                                                        <b><?php echo e(number_format($item->ucret * $doviz[$ayar['pb']] / $doviz[session()->get('pb')], 2)); ?>

                                                            <?php echo e(session()->get('pb')); ?></b>
                                                    </label>
                                                </li>

                                            <?php endif; ?>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>

                                </div>


                                <div class="col-lg-3"></div>
                                <div class="col-lg-3" style="background-size: 100%; background-repeat: no-repeat;">
                                    <button class="btn-main odeme pull-right"><i class="fa fa-credit-card-alt"></i>
                                        Kredi Kartı İle Ödeme Yap
                                    </button>
                                </div>
                                <div class="col-lg-3" style="background-size: 100%; background-repeat: no-repeat;">
                                    <a href="/havale?tur=transfer&arac=<?php echo e($request->arac); ?>&sorgu=<?php echo e($request->sorgu); ?>"
                                       class="btn-main pull-right odeme"><i class="fa fa-calendar-check-o"></i> Banka
                                        Transferi ile Ödeme Yap</a>
                                </div>
                                <div class="col-lg-3" style="background-size: 100%; background-repeat: no-repeat;">
                                    <a href="/sofor?arac=<?php echo e($request->arac); ?>&sorgu=<?php echo e($request->sorgu); ?>"
                                       class="btn-main pull-right odeme"><i class="fa fa-car"></i> Transferde Şöfore öde
                                        (+10%)</a>
                                </div>

                            </div>

                        </form>
                    </div>
                </div>
            </div>

            <div class="spacer-single" style="background-size: 100%; background-repeat: no-repeat;"></div>


        </div>
    </section>

    <style>

    </style>


    
    
    
    
    

    
    
    

    

    
    
    
    
    
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\transferpro2\resources\views/rezervasyon.blade.php ENDPATH**/ ?>