<?php $__env->startSection('icerik'); ?>

    <div class="pagetitle">
        <h1>Transfer Araçları</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/">Site</a></li>
                <li class="breadcrumb-item active">Transfer Araçları</li>
            </ol>
        </nav>
    </div><!-- End Page Title -->


    <section class="section dashboard">
        <div class="row">
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header"><i class="bx bx-plus-circle"></i> Araç Ekle</div>
                    <div class="card-body">

                        <form action="transferaracekle" class="arala" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            Araç Adı
                            <input required required type="text" class="form-control" name="isim"> Araç Tipi
                            <select name="tip" class="form-select" id="">
                                <?php $__currentLoopData = $aracTipleri; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($item); ?>"><?php echo e($item); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </select>
                            Model Yılı
                            <input required type="number" class="form-control" name="model">
                            Yakıt
                            <select name="yakit" class="form-select" id="">
                                <?php $__currentLoopData = $yakit; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($item); ?>"><?php echo e($item); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>Çekiş
                            <select name="cekis" class="form-select" id="">
                                <?php $__currentLoopData = $cekis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($item); ?>"><?php echo e($item); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            Yolcu Sayısı
                            <input required type="number" class="form-control" name="yolcu">
                            Bagaj Sayısı
                            <input required type="number" class="form-control" name="bagaj">
                            Kapı Sayısı
                            <input required type="number" class="form-control" name="kapi">

                            Araç Fotoğrafı
                            <input required type="file" accept="image/*" name="img" class="form-control">

                            Açılış Ücreti
                            <input required type="text" name="acilis" value="100" class="form-control">
                            KM Ücreti
                            <input required type="text" name="km" value="100" class="form-control">

                            <button class="btn btn-success"><i class="bx bxs-save"></i> Aracı Ekle</button>

                        </form>

                    </div>
                </div>
            </div>
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header"><i class="bx bx-plus-circle"></i> Araçlar</div>
                    <div class="card-body">
                        <table class="table table-hover">
                            <tr class="fw-bold">
                                <td>#</td>
                                <td>Foto</td>
                                <td>İsim</td>
                                <td>Model</td>
                                <td>Yakıt</td>
                                <td>Açılış</td>
                                <td>KM</td>
                                <td>Düzenle</td>
                                <td>Sil</td>
                            </tr>
                            <?php $__currentLoopData = $araclar; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($item->id); ?></td>
                                    <td><img src="/<?php echo e($item->img); ?>" width="50" class="arabafoto" alt=""></td>
                                    <td><?php echo e($item->isim); ?></td>
                                    <td><?php echo e($item->model); ?></td>
                                    <td><?php echo e($item->yakit); ?></td>
                                    <td><?php echo e($item->acilis); ?></td>
                                    <td><?php echo e($item->km); ?> </td>
                                    <td><a href="taracduzenle?id=<?php echo e($item->id); ?>" class="btn btn-sm btn-primary"><i class="bx bx-edit"></i> DÜzenle</a></td>
                                    <td><a onclick="silmi('/admin/taracsil?id=<?php echo e($item->id); ?>')" class="btn btn-sm btn-danger"><i class="bx bx-trash"></i> Sil</a></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <style>
        .arala * {
            margin-bottom: 5px;
            margin-top: 5px;
            clear: both
        }

        .arabafoto { border-radius: 5px; border: solid 0.5px darkgray; padding: 3px}
    </style>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('title','Transfer Araçları'); ?>

<?php echo $__env->make('panel.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\transferpro2\resources\views/admin/transferaraclari.blade.php ENDPATH**/ ?>