<!DOCTYPE html>
<html lang="tr">

<head>
    <title><?php echo $__env->yieldContent('title',''); ?> <?php echo e($ayar['title']); ?></title>
    <base href="/">
    <link rel="icon" href="images/icon.png" type="image/gif" sizes="16x16">
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="<?php echo e($ayar['description']); ?>" name="description">
    <meta content="" name="keywords">
    <meta content="" name="author">
    <!-- CSS Files
    ================================================== -->
    <link href="css/bootstrap.min.css" rel="stylesheet" type="text/css" id="bootstrap">
    <link href="css/mdb.min.css" rel="stylesheet" type="text/css" id="mdb">
    <link href="css/plugins.css" rel="stylesheet" type="text/css">
    <link href="css/style.css" rel="stylesheet" type="text/css">
    <link href="css/coloring.css" rel="stylesheet" type="text/css">
    <!-- color scheme -->
    <link id="colors" href="css/colors/scheme-01.css" rel="stylesheet" type="text/css">
</head>

<body onload="initialize()">
<div id="wrapper">

    <!-- page preloader begin -->
    <div id="de-preloader"></div>
    <!-- page preloader close -->

    <!-- header begin -->
    <header class="transparent scroll-light has-topbar">
        <div id="topbar" class="topbar-dark text-light">
            <div class="container">
                <div class="topbar-left xs-hide">
                    <div class="topbar-widget">
                        <div class="topbar-widget"><a href="#"><i class="fa fa-phone"></i><?php echo e($ayar['telefon']); ?></a>
                        </div>
                        <div class="topbar-widget"><a href="#"><i class="fa fa-envelope"></i><?php echo e($ayar['mail']); ?></a>
                        </div>
                        <div class="topbar-widget"><a href="#"><i class="fa fa-clock-o"></i><?php echo e($ayar['mesai']); ?></a>
                        </div>
                    </div>
                </div>

                <div class="topbar-right">
                    <div class="social-icons">






                        <?php if($ayar['gtranslate']==1): ?>
                        <div class="gtranslate_wrapper"></div>
                        <script>window.gtranslateSettings = {"default_language":"tr","detect_browser_language":true,"languages":["tr","en","de","fr","ar","zh-TW","it","ja","ru"],"wrapper_selector":".gtranslate_wrapper","flag_size":24,"flag_style":"3d","alt_flags":{"en":"usa"}}</script>
                        <script src="https://cdn.gtranslate.net/widgets/latest/flags.js" defer></script>







                       <?php else: ?>
                        <?php $socials = array('facebook', 'twitter', 'linkedin', 'pinterest', 'instagram', 'youtube'); ?>
                        <?php $__currentLoopData = $socials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <?php if(isset($ayar[$social])): ?>
                                <a href="<?php echo e($ayar[$social]); ?>"><i class="fa fa-<?php echo e($social); ?> fa-lg"></i></a>
                            <?php endif; ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>

                    </div>
                </div>
                <div class="clearfix"></div>
            </div>
        </div>
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="de-flex sm-pt10">
                        <div class="de-flex-col">
                            <div class="de-flex-col">
                                <!-- logo begin -->
                                <div id="logo">
                                    <a href="/">
                                        <img class="logo-1" src="images/logo-light.png" style="max-height: 50px;"
                                             alt="">
                                        <img class="logo-2" src="images/logo.png" style="max-height: 50px" alt="">
                                    </a>
                                </div>
                                <!-- logo close -->
                            </div>
                        </div>
                        <div class="de-flex-col header-col-mid">
                            <ul id="mainmenu">
                                <li><a class="menu-item" href="/">Ana Sayfa</a>

                                </li>
                                <li><a class="menu-item" href="/transfer">Transfer</a>

                                </li>
                                <li><a class="menu-item" href="/rent-a-car">Rent a Car</a>

                                </li>

                                <li><a class="menu-item" href="/panel">Hesabım</a>

                                    <?php if(auth()->check()): ?>

                                    <?php else: ?>
                                        <ul>
                                            <li><a href="/uye-ol" class="menu-item">Üye Ol</a></li>
                                            <li><a href="/giris-yap" class="menu-item">Giriş Yap</a></li>
                                        </ul>
                                    <?php endif; ?>
                                </li>
                                <li><a class="menu-item" href="/blog">Blog</a>

                                </li>
                                <li><a class="menu-item" href="/iletisim">İletişim</a>

                                </li>

                            </ul>
                        </div>
                        <div class="de-flex-col">
                            <div class="menu_side_area">
                                <?php if(auth()->check()): ?>

                                    <a href="/panel" class="btn-main"><span class="fa fa-user-circle-o"></span> Panelim</a>
                                    <?php if(auth()->user()->rol=='admin'): ?>
                                        <a href="/admin" target="_blank" class="btn-main"><span class="fa fa-cogs"></span> Admin</a>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <a href="/login" class="btn-main"><span class="fa fa-sign-in"></span> Üyelik</a>
                                <?php endif; ?>

                                <span id="menu-btn"></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <!-- header close -->
    <!-- content begin -->
    <div class="no-bottom no-top" id="content">
        <div id="top"></div>
        <div
            style="background-color: #1a1e21; height: 140px; width: 100%"
            class="ustarka"></div>


        <?php echo $__env->yieldContent('icerik'); ?>

        <section id="section-call-to-action" class="bg-color-2 pt60 pb60 text-light">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6 offset-lg-1">
                        <h2 class="s2">Detaylı bilgi ve yardım için bize ulaşmaktan çekinmeyin.</h2>
                    </div>

                    <div class="col-lg-5 text-lg-center text-sm-center">
                        <div class="phone-num-big">
                            <i class="fa fa-phone"></i>
                            <span class="pnb-text">
                                    Hemen Ara
                                </span>
                            <span class="pnb-num">
                                    <?php echo e($ayar['telefon']); ?>

                                </span>
                        </div>
                        <a href="/iletisim" class="btn-main">İletişim Bilgileri</a>
                    </div>
                </div>
            </div>
        </section>

    </div>
    <!-- content close -->
    <a href="#" id="back-to-top"></a>
    <!-- footer begin -->
    <footer class="text-light">
        <div class="container">
            <div class="row g-custom-x">
                <div class="col-lg-3">
                    <div class="widget">
                        <h5><?php echo e($ayar['siteadi']); ?> Hakkında</h5>
                        <p><?php echo e($ayar['footerhakkinda']); ?></p>
                    </div>
                </div>

                <div class="col-lg-3">
                    <div class="widget">
                        <h5>İletişim Bilgileri</h5>
                        <address class="s1">
                            <span style="font-size: 13px!important;"><i class="id-color fa fa-map-marker fa-lg"></i><?php echo e($ayar['adres']); ?></span>
                            <span><i class="id-color fa fa-phone fa-lg"></i><?php echo e($ayar['telefon']); ?></span>
                            <span><i class="id-color fa fa-envelope-o fa-lg"></i><a
                                    href="mailto:<?php echo e($ayar['mail']); ?>"><?php echo e($ayar['mail']); ?></a></span>
                            <span><i class="id-color fa fa-file-pdf-o fa-lg"></i><a
                                    href="/basin-kiti">Basın Kiti</a></span>
                        </address>
                    </div>
                </div>

                <div class="col-lg-3">
                    <h5>Önemli Linkler</h5>
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="widget">
                                <ul>
                                    <?php $__currentLoopData = $linkler; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><a href="<?php echo e($link->link); ?>"><?php echo e($link->baslik); ?></a></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3">
                    <div class="widget">
                        <h5>Sosyal Medya</h5>
                        <div class="social-icons">
                            <?php $socials = array('facebook', 'twitter', 'linkedin', 'pinterest', 'instagram', 'youtube'); ?>
                            <?php $__currentLoopData = $socials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <?php if(isset($ayar[$social])): ?>
                                    <a href="<?php echo e($ayar[$social]); ?>"><i class="fa fa-<?php echo e($social); ?> fa-lg"></i></a>
                                <?php endif; ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="subfooter">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="de-flex">
                            <div class="de-flex-col">
                                <a href="/">
                                    Copyright <?php echo e(date('Y')); ?> - <?php echo e($ayar['siteadi']); ?>

                                </a>
                            </div>
                            <ul class="menu-simple">
                                <li><a href="/kullanim-sozlesmesi/">Kullanım Sözleşmesi</a></li>
                                <li><a href="/gizlilik-guvenlik/">Gizlilik &amp; Güvenlik</a></li>
                                <li><a href="/kvkk/">KVKK</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <!-- footer close -->
</div>


<!-- Javascript Files
================================================== -->
<script src="js/plugins.js"></script>
<script src="js/designesia.js"></script>


<script src="https://maps.googleapis.com/maps/api/js?key=<?php echo e($ayar['googlemaps']); ?>&libraries=places&callback=initPlaces&types=point_of_interest,establishment,address,regions,locality" async="" defer=""></script>
</body>

<style>
    .saatsec {
        color: white !important;
    }

    .saatsec:focus {
        color: red !important;
    }
</style>

<!--error handling-->


<?php if(session()->has('success')): ?>

    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        Swal.fire({
            icon: 'success',
            title: 'İşlem Başarılı',
            text: '<?php echo e(session()->get('success')); ?>',
            timer: 60500

        })
    </script>
<?php endif; ?>

<?php if(session()->has('errors')): ?>

    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        Swal.fire({
            icon: 'error',
            title: 'Hata',
            text: '<?php echo e(session()->get('errors')); ?>'

        })
    </script>
<?php endif; ?>
<!--error handling-->

</html>
<?php /**PATH /home/ucretsizscript/transferpro.ucretsizscript.net/resources/views/master.blade.php ENDPATH**/ ?>