@extends('master')
@section('icerik')
    <section id="section-cars" style="background-size: 100%; background-repeat: no-repeat;">
        <div class="container" style="background-size: 100%; background-repeat: no-repeat;">
            <div class="row" style="background-size: 100%; background-repeat: no-repeat;">

                <h3>Popüler Turlar</h3>

                <div class="kats " style="width: 100%!important;">
                    @foreach($turkat as $item)
                        <a href="/turlar/{{ $item->slug }}" class="btn btn-primary mb10"> <i class="fa fa-paperclip"></i> {{ $item->turkat }}</a>
                    @endforeach
                </div>

                <hr class="mt-2">

                @if(count($turlar)>0)
                <div class="row">

                    @foreach($turlar as $item)

                        <div class="col-xl-4 col-md-6 col-sm-12">
                            <div class="de-item mb30">

                                <i class="fa fa-heart favtur mr10 mt10" style="float: right"></i>

                                <div class="d-text" style="background-size: 100%; background-repeat: no-repeat;">
                                    <h3 class="ml20 mt10">{{ $item->baslik }}</h3>


                                </div>

                                <div class="clearfix"></div>


                                <div class="input-group" style="font-size: 12px; margin-left: 5%; margin-right: 5%">
                                    <div class="mr10"><i class="fa fa-tag"></i> {{ $item->turkat }}</div>
                                   @isset($item->star) <div><i class="fa fa-star gold"></i> {{ $item->star }}</div>@endisset

                                </div>

                                <div class="card-body">
                                    <img src="{{ $item->img }}" alt="">
                                </div>





                                <div class="d-price ml20" style="background-size: 100%; background-repeat: no-repeat;">

                                    @if($ayar['pb']==session()->get('pb'))
                                    Başlangıç Fiyatı <span>{{$item->price}}<small>  {{ $ayar['pb'] }}</small>  <i class="fa fa-refresh"  onclick="modal('parabirimi','')"></i></span>
                                    @else
                                        Başlangıç Fiyatı <span>{{ number_format(($item->price * $doviz[$ayar['pb']]) / $doviz[session()->get('pb')], 2) }} <small>{{ session()->get('pb') }}</small>  <i class="fa fa-refresh"  onclick="modal('parabirimi','')"></i></span>
                                        @endif
                                    <a class="btn-main mr20" href="/tur/{{ $item->turslug }}">Turu İncele</a>
                                </div>


                                <p></p>



                            </div>
                        </div>

                    @endforeach

                </div>
                @else
                <div class="alert-warning container alert"> Aradığınız kriterlerde aktif tur bulunamadı.</div>
                @endif
            </div>
        </div>
    </section>

    <style>
        .popular-tour {

            text-align: center;
            margin-bottom: 25px;
            border-radius: 20px;
            background: #fff;
            box-shadow: 0 0 30px 0 rgb(51 51 51/10%);
            transition: .25s;
            padding: 10px;
            min-height: 350px;
        }
        .popular-tour:hover {


            box-shadow: 0 0 30px 0 rgb(51 51 51/30%);
            transition: .25s;
        }

        .de-item img {
            width: 95%;
            /* aspect-ratio: 1/1; */
            object-fit: contain;
            opacity: 1!important;
            border-radius: 10px;
            margin-top: 10px;
            max-height: 225px;
        }

        .gold { color:goldenrod}

        .de-item:hover img {
            transform: scale(1.2); /* veya istediğiniz zoom oranını buradan ayarlayabilirsiniz */
        }

    </style>


@endsection
@section('title','Turlar • ')
