@extends('master')
@section('icerik')

    <section id="section-cars" class="bg-gray-100" style="background-size: 100%; background-repeat: no-repeat;">
        <div class="container" style="background-size: 100%; background-repeat: no-repeat;">
            <div class="row" style="background-size: 100%; background-repeat: no-repeat;">
                <div class="col-lg-3 mb30" style="background-size: 100%; background-repeat: no-repeat;">
                    <div class="card p-4 rounded-5" style="background-size: 100%; background-repeat: no-repeat;">
                        <div class="profile_avatar" style="background-size: 100%; background-repeat: no-repeat;">
                            <div class="profile_img" style="background-size: 100%; background-repeat: no-repeat;">
                                <img src="images/np.png" alt="">
                            </div>
                            <div class="profile_name" style="background-size: 100%; background-repeat: no-repeat;">
                                <h4>
                                    {{ ucwords($uye->name) }}
                                    <span class="profile_username text-gray">{{ $uye->email }}</span>
                                </h4>
                            </div>
                        </div>
                        <div class="spacer-20" style="background-size: 100%; background-repeat: no-repeat;"></div>
                        <ul class="menu-col">

                            <li><a href="/panel/profil" @if($alt=="profil" || $alt=="") class="active" @endif><i class="fa fa-user"></i>Profilim</a></li>
                            <li><a href="/panel/transfer" @if($alt=="transfer") class="active" @endif><i class="fa fa-calendar"></i>Transferlerim</a></li>
                            <li><a href="/panel/kiralama" @if($alt=="kiralama") class="active" @endif><i class="fa fa-car"></i>Araç Kiralamalarım</a></li>
                            <li><a href="/logout"><i class="fa fa-sign-out"></i>Güvenli Çıkış</a></li>
                        </ul>
                    </div>
                </div>

                <style>
                    .os { overflow-x: scroll!important;}

                </style>
                <div class="col-lg-9" style="background-size: 100%; background-repeat: no-repeat;">

                    @if($alt=="transfer")
                    <div class="os card p-4 rounded-5 mb25" style="background-size: 100%; background-repeat: no-repeat;">
                        <h4>Transferlerim</h4>

                        <table class="table table-hover">
                            <thead>
                            <tr>
                                <th scope="col"><span class="text-uppercase fs-12 text-gray">No</span></th>
                                <th scope="col"><span class="text-uppercase fs-12 text-gray">Yön</span></th>

                                <th scope="col"><span class="text-uppercase fs-12 text-gray">Alınma Adresi</span></th>
                                <th scope="col"><span class="text-uppercase fs-12 text-gray">Bırakılma Adresi</span></th>
                                <th scope="col"><span class="text-uppercase fs-12 text-gray">Alınma</span></th>
                                <th scope="col"><span class="text-uppercase fs-12 text-gray">Bırakılma</span></th>
                                <th scope="col"><span class="text-uppercase fs-12 text-gray">Durum</span></th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($transfer as $item)
                            <tr>
                                <td><div class="badge bg-gray-100 text-dark" style="background-size: 100%; background-repeat: no-repeat;">TP{{ $item->id  }}</div></td>

                                <td>{{ substr($item->yon,0,30)}}</td>
                                <td>{{ substr($item->alinmanoktasi,0,30)}}...</td>
                                <td>{{ substr($item->birakilmanoktasi,0,30)}}...</td>
                                <td>{{\Carbon\Carbon::createFromDate($item->alinmatarihi)->format('d/m/Y h:i') }}</td>
                                <td>{{\Carbon\Carbon::createFromDate($item->birakilmatarihi)->format('d/m/Y h:i') }}</td>
                                <td>
                                    @if($item->durum=="Havale Bekleniyor")
                                        <a href="/havale?tur=transfer&arac={{ $item->arac }}&sorgu={{ $item->id }}&tek={{ $item->tek }}&cift={{ $item->cift }}" class="badge rounded-pill bg-info" style="background-size: 100%; background-repeat: no-repeat;">
                                            {{ $item->durum }}</a>
                                        @else
                                    <div class="badge rounded-pill bg-info" style="background-size: 100%; background-repeat: no-repeat;">
                                    {{ $item->durum }}</div>
                                    @endif
                                </td>
                            </tr>
                            @endforeach

                            </tbody>
                        </table>
                    </div>
                    @endif

                    @if($alt=="kiralama")
                            <div class="card p-4 rounded-5 mb25" style="background-size: 100%; background-repeat: no-repeat;">
                                <h4>Araç Kiralamalarım</h4>

                                <table class="table table-hover">
                                    <thead>
                                    <tr>
                                        <th scope="col"><span class="text-uppercase fs-12 text-gray">#</span></th>
                                        <th scope="col"><span class="text-uppercase fs-12 text-gray">Araç</span></th>

                                        <th scope="col"><span class="text-uppercase fs-12 text-gray">Alınma T</span></th>
                                        <th scope="col"><span class="text-uppercase fs-12 text-gray">Bırakılma T</span></th>

                                        <th scope="col"><span class="text-uppercase fs-12 text-gray">Durum</span></th>
                                        <th scope="col"><span class="text-uppercase fs-12 text-gray">Sorgula</span></th>

                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($kiralama as $item)
                                        <tr>
                                    <td><div class="badge bg-gray-100 text-dark" style="background-size: 100%; background-repeat: no-repeat;">K{{ $item->kid  }}</div></td>
                                    <td>{{ $item->isim }}</td>
                                    <td>{{ \Illuminate\Support\Carbon::createFromDate($item->alinma)->format('d/m/Y') }}</td>
                                    <td>{{ \Illuminate\Support\Carbon::createFromDate($item->birakilma)->format('d/m/Y') }}</td>
                                    <td>{{ $item->durum }}</td>
                                            <td><a href="/arac-kirala?id={{ $item->aracid }}&alinma={{ $item->alinma }}&birakilma={{ $item->birakilma }}" class="btn btn-sm btn-outline-info"><i class="fa fa-search"></i> Tekrar Ara</a></td>

                                        </tr>
                                @endforeach
                                    </tbody>
                                </table>

                            </div>
                        @endif

                        @if($alt=="profil" || $alt=="")
                            <div class="card p-4 rounded-5 mb25" style="background-size: 100%; background-repeat: no-repeat;">
                                <h4>Profilim</h4>

                                <form action="/profilduzenle" method="post" class="aro">
                                    @csrf
                                    Adınız
                                    <input type="text" name="name" class="form-control" value="{{ auth()->user()->name }}">
                                    E-mail
                                    <input type="text" name="email" class="form-control" value="{{ auth()->user()->email }}">
                                    Telefon
                                    <input type="text" name="telefon" class="form-control" value="{{ auth()->user()->telefon }}">
                                    <br>
                                    <button type="submit" class="btn-main">Güncelle</button>
                                </form>

                            </div>
                            <style>
                                .aro input { margin-bottom: 10px;}
                                .gizle { display: none!important;}
                            </style>
                        @endif

                </div>
            </div>
        </div>
    </section>

@endsection
