@extends('panel.index')
@section('icerik')

    <div class="pagetitle">
        <h1>Turlar</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/">Site</a></li>
                <li class="breadcrumb-item active">Turlar</li>
            </ol>
        </nav>
    </div><!-- End Page Title -->


    <section class="section dashboard">
        <div class="row">
            <div class="col-lg-12">
                <div class="alert-info alert">
                    <a href="turlar#turlist">Önceden eklenmiş turları görmek için buraya tıklayın</a>
                </div>

                <div class="card">
                    <div class="card-header"><i class="bx bx-plus-circle"></i> Tur Ekle</div>
                    <div class="card-body">

                        <form action="turekle" class="arala" method="post" enctype="multipart/form-data">
                            @csrf

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="baslik">Tur Adı</label>
                                        <input required type="text" class="form-control" name="baslik">
                                    </div>

                                    <div class="form-group">
                                        <label for="katid">Tur Kategorisi</label>
                                        <select name="katid" class="form-select">
                                            <option>Kategori Seçiniz</option>
                                            @foreach($kat as $item)
                                                <option value="{{ $item->id }}">{{ $item->turkat }}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="form-group">
                                        <label for="star">Öne Çıkan Özellik</label>
                                        <input required type="text" class="form-control" name="star" value="Otelden Alınır">
                                    </div>

                                    <div class="form-group">
                                        <label for="baslama">Başlama Saati</label>
                                        <input required type="text" class="form-control" name="baslama" value="09:00">
                                    </div>

                                    <div class="form-group">
                                        <label for="bitis">Bitiş Saati</label>
                                        <input required type="text" class="form-control" name="bitis" value="20:00">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="yetiskin">Yetişkin Fiyat</label>
                                        <input required type="text" class="form-control" name="yetiskin">
                                    </div>

                                    <div class="form-group">
                                        <label for="bcocuk">Büyük Çocuk Fiyat</label>
                                        <input required type="text" class="form-control" name="bcocuk">
                                    </div>

                                    <div class="form-group">
                                        <label for="kcocuk">Küçük Çocuk Fiyat</label>
                                        <input required type="text" class="form-control" name="kcocuk">
                                    </div>

                                    <div class="form-group">
                                        <label for="bebek">Bebek Fiyat</label>
                                        <input required type="text" class="form-control" name="bebek">
                                    </div>

                                    <div class="form-group">
                                        <label for="img">Kapak Fotoğrafı</label>
                                        <input required type="file" accept="image/*" name="img" class="form-control">
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                Tur Kısa Tanım
                                <textarea name="turkisatanim" class="form-control" id="" cols="30" rows="5" placeholder="2 paragraf tur kısa tanım"></textarea>
                            </div>

                            <div class="form-group">
                                <label for="program">Tur Tanıtımı</label>
                                <div class="editor-container">
                                    <textarea id="editor" name="program"></textarea>
                                </div>
                                <script>
                                    ClassicEditor
                                        .create(document.getElementById('editor'))
                                        .then(editor => {
                                            console.log('Editor was initialized');
                                        })
                                        .catch(error => {
                                            console.error(error);
                                        });
                                </script>
                            </div>

                            <button class="btn btn-success"><i class="bx bxs-save"></i> Tur Ekle</button>
                        </form>


                    </div>
                </div>
            </div>

            <div class="col-lg-12">
                <a name="turlist"></a>
                <div class="card">
                    <div class="card-header"><i class="bx bx-plus-circle"></i> Turlar</div>
                    <div class="card-body">
                        <table class="table table-hover">
                            <tr class="fw-bold">
                                <td>#</td>
                                <td>Baslık</td>
                                <td>Kategori</td>
                                <td>Özellik</td>
                                <td>Saatler</td>
                                <td>Yetişkin</td>
                                <td>B.Çocuk</td>
                                <td>K.Çocuk</td>
                                <td>Bebek</td>
                                <td>Düzenle</td>
                                <td>Sil</td>
                            </tr>
                            @foreach($tur as $item)

                                <tr>
                                    <td>{{ $item->turlar_id }}</td>
                                    <td>{{ $item->baslik }}</td>
                                    <td>{{ $item->turkat }}</td>
                                    <td>{{ $item->star }}</td>
                                    <td>{{ $item->baslama }} - {{$item->bitis}}</td>
                                    <td>{{ $item->yetiskin }}</td>
                                    <td>{{ $item->bcocuk }}</td>
                                    <td>{{ $item->kcocuk }}</td>
                                    <td>{{$item->bebek}}</td>
                                    <td><a href="turduzenle?id={{$item->turlar_id}}" class="btn btn-sm btn-primary">Düzenle</a></td>
                                    <td><div onclick="silmi('tursil?id={{$item->turlar_id}}')"  class="btn btn-sm btn-danger">Sil</div></td>
                                </tr>
                            @endforeach
                          </table>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <style>
        .arala * {
            margin-bottom: 5px;
            margin-top: 5px;
            clear: both
        }

        .arabafoto { border-radius: 5px; border: solid 0.5px darkgray; padding: 3px}
    </style>
    <style>
        /* Set the height of the textarea to 30% of the viewport height */
        #editor {
            height: 30vh;
        }
    </style>
@endsection

@section('title','Turlar')
