@extends('panel.index')
@section('icerik')
    <style>
        .mw200 {
            max-width: 200px;
        }
    </style>
    <div class="pagetitle">
        <h1>Kiralama Talepleri</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/">Site</a></li>
                <li class="breadcrumb-item active">Kiralama Talepleri</li>
            </ol>
        </nav>
    </div><!-- End Page Title -->


    <section class="section dashboard">
        <div class="col-12">
            <div class="card">

                <div class="filter">
                    <a class="icon" href="#" data-bs-toggle="dropdown"><i class="bi bi-filter"></i> Filtrele</a>
                    <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                        <li class="dropdown-header text-start">
                            <h6>Durum</h6>
                        </li>

                        <li><a href="kiralama-talepleri" class="dropdown-item">Hepsi</a></li>
                        @foreach($durums as $item)
                            <li><a class="dropdown-item @if($item->durum==$request->durum) fw-bold @endif"
                                   href="kiralama-talepleri?durum={{ $item->durum }}">{{ $item->durum }}</a></li>
                        @endforeach

                    </ul>
                </div>

                <div class="card-body">
                    <h5 class="card-title">Talepler <span></span></h5>


                    <table class="table table-hover">
                        <tr class="fw-bold">
                            <td>Id</td>
                            <td>Müşteri</td>
                            <td>Araç</td>
                            <td>Alma</td>
                            <td>Bırakma</td>


                            <td>Durum</td>

                            <td>Sil</td>
                        </tr>

                        @foreach($kiralama as $item)
                            <tr>
                                <td>{{ $item->kid }}</td>
                                {{--                                <td>{{ $item->yon }}</td>--}}
                                <td>{{ ucwords($item->name) }} <br> {{ $item->telefon }}</td>
                                <td>{{ $item->isim }}</td>
                                <td class="mw200"><i
                                        class="bx bx-calendar"></i> {{ \Carbon\Carbon::createFromDate($item->alinma)->format('d/m/Y') }}
                                </td>
                                <td class="mw200"><i
                                        class="bx bx-calendar"></i> {{ \Carbon\Carbon::createFromDate($item->birakilma)->format('d/m/Y') }}
                                </td>


                                <td>{{ $item->durum }}</td>


                                <td>
                                    <div onclick="silmi('/admin/ktalepsil?id={{ $item->kid }}')"
                                         class="btn btn-sm btn-danger"><i class="bi-trash bi"></i> Sil
                                    </div>
                                </td>


                            </tr>
                        @endforeach
                    </table>


                </div>

            </div>
        </div>
    </section>

@endsection
@section('title','Kiralama Talepleri')
