@extends('panel.index')
@section('icerik')

    <div class="pagetitle">
        <h1>Hesap N</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/">Site</a></li>
                <li class="breadcrumb-item active">Hesap Numaraları</li>
            </ol>
        </nav>
    </div><!-- End Page Title -->


    <section class="section dashboard">
        <div class="row">
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header"><i class="bx bx-plus-circle"></i> Hesap Numarası Ekle</div>
                    <div class="card-body">

                        <form action="hesapnoekle" class="arala" method="post" enctype="multipart/form-data">
                            @csrf
                            Banka Adı
                            <input required required type="text" class="form-control" name="bankaadi">

                           Hesap Sahibi
                            <input required type="text" class="form-control" name="hesapsahibi">
                          IBAN
                            <input required type="text" class="form-control" name="iban">


                            <button class="btn btn-success"><i class="bx bxs-save"></i>  Ekle</button>

                        </form>

                    </div>
                </div>
            </div>
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header"><i class="bx bx-money-withdraw"></i> Hesap Numaraları</div>
                    <div class="card-body">
                        <table class="table table-hover">
                            <tr class="fw-bold">
                                <td>#</td>
                                <td>Banka</td>
                                <td>Hesap Sahibi</td>
                                <td>IBAN</td>

                                <td>Düzenle</td>
                                <td>Sil</td>
                            </tr>
                            @foreach($hesapno as $item)
                                <tr>
                                    <td>{{ $item->id }}</td>

                                    <td>{{ $item->bankaadi }}</td>
                                    <td>{{ $item->hesapsahibi }}</td>
                                    <td>{{ $item->iban }}</td>

                                    <td><a href="hesapnoduzenle?id={{ $item->id }}" class="btn btn-sm btn-primary"><i class="bx bx-edit"></i> DÜzenle</a></td>
                                    <td><a onclick="silmi('/admin/hesapnosil?id={{ $item->id }}')" class="btn btn-sm btn-danger"><i class="bx bx-trash"></i> Sil</a></td>
                                </tr>
                            @endforeach
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <style>
        .arala * {
            margin-bottom: 5px;
            margin-top: 5px;
            clear: both
        }

        .arabafoto { border-radius: 5px; border: solid 0.5px darkgray; padding: 3px}
    </style>

@endsection
@section('title','Transfer Araçları')
