@extends('panel.index')
@section('icerik')

    <div class="pagetitle">
        <h1>Blog Yönetimi</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/">Site</a></li>
                <li class="breadcrumb-item active">Blog Yönetimi</li>
            </ol>
        </nav>
    </div><!-- End Page Title -->


    <section class="section dashboard">
        <div class="row">
            <div class="col-lg-5">
                <div class="card">
                    <div class="card-header"><i class="bx bx-plus-circle"></i> Blog İçeriği EKle</div>
                    <div class="card-body">

                        <form action="blogekle" class="arala" method="post" enctype="multipart/form-data">
                            @csrf
                            Başlık
                            <input required required type="text" class="form-control" name="baslik">

                           İçerik

                            <textarea name="icerik" cols="10" class="form-control" rows="20" ></textarea>

                            <button class="btn btn-success"><i class="bx bxs-save"></i>  Ekle</button>

                        </form>

                    </div>
                </div>
            </div>
            <div class="col-lg-7">
                <div class="card">
                    <div class="card-header"><i class="bx bx-pencil"></i> Geçmiş Bloglar</div>
                    <div class="card-body">
                        <table class="table table-hover">
                            <tr class="fw-bold">
                                <td>#</td>
                                <td>Başlık</td>
                                <td>Tarih</td>


                                <td>Düzenle</td>
                                <td>Sil</td>
                            </tr>
                            @foreach($blog as $item)
                                <tr>
                                    <td>{{ $item->id }}</td>

                                    <td>{{ $item->baslik }}</td>
                                    <td>{{ \Carbon\Carbon::createFromDate($item->tarih)->format('d/m/Y') }}</td>


                                    <td><a href="blogduzenle?id={{ $item->id }}" class="btn btn-sm btn-primary"><i class="bx bx-edit"></i> Düzenle</a></td>
                                    <td><a onclick="silmi('/admin/blogsil?id={{ $item->id }}')" class="btn btn-sm btn-danger"><i class="bx bx-trash"></i> Sil</a></td>
                                </tr>
                            @endforeach
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <style>
        .arala * {
            margin-bottom: 5px;
            margin-top: 5px;
            clear: both
        }

        .arabafoto { border-radius: 5px; border: solid 0.5px darkgray; padding: 3px}
    </style>

@endsection
@section('title','Transfer Araçları')
