<?php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class YoneticiMiddleware
{
    public function handle(Request $request, Closure $next)
    {


        // URL '/admin/' ile başlamıyorsa devam et
        if (!str_starts_with($request->getPathInfo(), '/admin')) {
            return $next($request);
        }

        // Oturum açmamış veya rolü 'admin' değilse yönlendirme yapma
        if (!auth()->check() || $request->user()->rol !== 'admin') {
            return redirect('/login');
        }

        // Diğer durumlar için devam et
        return $next($request);
    }
}
