<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use PHPUnit\Exception;

class yonetici extends Controller
{


function hesapnoekle(Request$request)
{
    DB::table('hesapno')->insert(['bankaadi'=>$request->bankaadi,'hesapsahibi'=>$request->hesapsahibi,'iban'=>$request->iban]);
    return redirect()->back()->with('success','eklendi');
}

function hesapnosil(Request$request)
{
    DB::table('hesapno')->where('id',$request->id)->delete();
    return redirect()->back()->with('success','silindi');
}

    function admin(Request $request)
    {

        DB::table('users')->where('utarih', null)->update(['utarih' => date('Y-m-d')]);

        $transfer = DB::table('transfer')->where('tarih', 'like', date('Y-m-d') . "%")->count();
        $kiralama = DB::table('kiralama')->where('tarih', 'like', date('Y-m') . "%")->count();
        $musteri = DB::table('users')->where('utarih', 'like', date('Y') . "%")->where('rol', '<>', 'admin')->count();
        $musteriler = DB::table('users')->where('rol', '<>', 'admin')->orderBy('id', 'desc')->paginate('15');

        // Talep sayısı (sales)
        $sales = DB::table('transfer')->select(DB::raw('DATE(tarih) as date'), DB::raw('COUNT(*) as count'))->groupBy('date')->get();

        // Kiralama talebi sayısı (revenue)
        $revenue = DB::table('kiralama')->select(DB::raw('DATE(tarih) as date'), DB::raw('COUNT(*) as count'))->groupBy('date')->get();

        // Müşteri sayısı (customer)
        $customers = DB::table('users')->select(DB::raw('DATE(utarih) as date'), DB::raw('COUNT(*) as count'))->where('rol', 'musteri')->groupBy('date')->get();

        // Tarih formatını dönüştürmek için Carbon kullanıyoruz
        foreach ($sales as $sale) {
            $sale->date = Carbon::createFromFormat('Y-m-d', $sale->date)->format('Y-m-d\TH:i:s.000\Z');
        }

        foreach ($revenue as $rev) {
            $rev->date = Carbon::createFromFormat('Y-m-d', $rev->date)->format('Y-m-d\TH:i:s.000\Z');
        }

        foreach ($customers as $customer) {
            $customer->date = Carbon::createFromFormat('Y-m-d', $customer->date)->format('Y-m-d\TH:i:s.000\Z');
        }


        return view('admin.index', compact('request', 'transfer', 'kiralama', 'musteri', 'musteriler', 'sales', 'revenue', 'customers'));


    }

    function musteriler(Request $request)
    {
        $musteri = DB::table('users')->where('rol', 'musteri')->orderBy('id', 'desc');

        if (isset($request->kelime)) {
            $musteri->where('name', 'like', '%' . $request->kelime . '%');
        }


        $musteri = $musteri->paginate('300');
        return view('admin.musteriler', compact('musteri', 'request'));
    }

    function transfertalepleri(Request $request)
    {
        $durum = DB::table('durum')->where('t', 'T')->get();
        $transfer = DB::table('transfer')->select('*', 'transfer.id as talepid')->join('users', 'transfer.username', '=', 'users.id')->orderBy('transfer.id', 'desc');
        if (isset($request->user)) {
            $transfer->where('username', $request->user);
        }
        if (isset($request->durum)) {
            $transfer->where('durum', $request->durum);
        }
        $transfer = $transfer->paginate('200');
        $durums = DB::table('transfer')->select('durum')->groupBy('durum')->get();
        return view('admin.transfer', compact('transfer', 'request', 'durums', 'durum'));
    }

    function turtalepleri(Request $request)
    {

        $tur = DB::table('tursip')
            ->join('turlar', 'tursip.turid', '=', 'turlar.id')
            ->join('users', 'tursip.userid', '=', 'users.id')
            ->select(
                'tursip.id as tursip_id',
                'turlar.id as turlar_id',
                'users.id as users_id',
                'tursip.*',
                'turlar.*',
                'users.*'
            )
            ->orderBy('tursip.id', 'desc')
            ->paginate(200);

        return view('admin.turtalep', compact('tur', 'request'));
    }

    function kiralamatalepleri(Request $request)
    {
        $kiralama = DB::table('kiralama')->join('kiralik_arac', 'kiralama.aracid', 'kiralik_arac.id')->join('users', 'kiralama.userid', '=', 'users.id')->orderBy('kid', 'desc');
        if (isset($request->user)) {
            $kiralama->where('userid', $request->user);
        }
        if (isset($request->durum)) {
            $kiralama->where('durum', $request->durum);
        }
        $kiralama = $kiralama->paginate('200');


        $durums = DB::table('kiralama')->select('durum')->groupBy('durum')->get();
        return view('admin.kiralama', compact('kiralama', 'request', 'durums'));
    }

    function pasifyap(Request $request)
    {
        DB::table('users')->where('id', $request->id)->update(['aktif' => 0]);
        return redirect()->back()->with('success', 'Pasif Yapıldı');
    }

    function aktifyap(Request $request)
    {
        DB::table('users')->where('id', $request->id)->update(['aktif' => 1]);
        return redirect()->back()->with('success', 'Aktif Yapıldı');
    }


    function transferaraclari(Request $request)
    {

        $aracTipleri = ['Otomobil', 'Minibüs', 'Kamyonet', 'Panelvan', 'SUV'];
        $yakit = ['Benzin', 'Dizel', 'Benzin/LPG', 'Hibrit', 'Elektrik'];
        $cekis = ['Ön', 'Arka', '4x4'];
        $araclar = DB::table('transfer_arac')->paginate(100);
        return view('admin.transferaraclari', compact('araclar', 'request', 'aracTipleri', 'yakit', 'cekis'));

    }

    function kiralikaraclar(Request $request)
    {
        $yakit = ['Benzin', 'Dizel', 'Benzin/LPG', 'Hibrit', 'Elektrik'];
        $cekis = ['Ön', 'Arka', '4x4'];
        $tip = ['Sedan', 'Hatchback', 'Station Wagon', 'SUV', 'Crossover', 'Coupe', 'Cabriolet / Convertible', 'MPV', 'Minivan', 'Pick-up'];

        $araclar = DB::table('kiralik_arac')->paginate('100');
        return view('admin.kiralikarac', compact('request', 'araclar', 'yakit', 'tip'));
    }

    function taracsil(Request $request)
    {

        $img = DB::table('transfer_arac')->where('id', $request->id)->first();
        //  unlink(public_path('/') . $img->img);
        DB::table('transfer_arac')->where('id', $request->id)->delete();
        return redirect()->back()->with('success', 'Kayıt Silindi');
    }

    function taracduzenle(Request $request)
    {
        $aracTipleri = ['Otomobil', 'Minibüs', 'Kamyonet', 'Panelvan', 'SUV'];
        $yakit = ['Benzin', 'Dizel', 'Benzin/LPG', 'Hibrit', 'Elektrik'];
        $cekis = ['Ön', 'Arka', '4x4'];
        $arac = DB::table('transfer_arac')->where('id', $request->id)->first();
        return view('admin.taracduzenle', compact('request', 'arac', 'aracTipleri', 'yakit', 'cekis'));

    }

    function icu(Request $request)
    {
        $formData = $request->all();

        foreach ($formData as $key => $value) {

            // Key-value çiftlerini kullanarak istediğiniz işlemleri yapabilirsiniz
            // echo "'" . $key . "'=>$" . "request->" . $key . ',';
            echo $key . "." . $value;
        }


    }

    function taracekle(Request $request)
    {

        $img = null;
        if ($request->hasFile('img')) {

            try {
                $file = $request->file('img');

                if ($file->isValid() && strpos($file->getMimeType(), 'image/') === 0) {
                    $imageName = time() . '.' . $file->getClientOriginalExtension();
                    $file->move(public_path('img'), $imageName);
                    $img = 'img/' . $imageName;
                }

                DB::table('transfer_arac')->insert(['isim' => $request->isim, 'tip' => $request->tip, 'model' => $request->model, 'yakit' => $request->yakit, 'cekis' => $request->cekis, 'yolcu' => $request->yolcu, 'bagaj' => $request->bagaj, 'kapi' => $request->kapi, 'acilis' => $request->acilis, 'km' => $request->km, 'img' => $img]);

                return redirect()->back()->with('success', 'Araç Eklendi');
            } catch (\Exception $e) {
                return redirect()->back()->with('errors', 'Araç Eklenemedi:' . $e->getMessage());
            }


//$this->icu($request);


        } else {
            return redirect()->back()->with('errors', 'İşlem başarısız');
        }


    }

    function karacekle(Request $request)
    {

        $img = null;
        if ($request->hasFile('img')) {

            try {
                $file = $request->file('img');

                if ($file->isValid() && strpos($file->getMimeType(), 'image/') === 0) {
                    $imageName = time() . '.' . $file->getClientOriginalExtension();
                    $file->move(public_path('img'), $imageName);
                    $img = 'img/' . $imageName;
                }

                DB::table('kiralik_arac')->insert(['isim' => $request->isim, 'tip' => $request->tip, 'model' => $request->model, 'yakit' => $request->yakit, 'yolcu' => $request->yolcu, 'bagaj' => $request->bagaj, 'kapi' => $request->kapi, 'img' => $img, 'ucret1' => $request->ucret1, 'ucret30' => $request->ucret30, 'ucret180' => $request->ucret180, 'ucret360' => $request->ucret360]);

                return redirect()->back()->with('success', 'Araç Eklendi');
            } catch (\Exception $e) {
                return redirect()->back()->with('errors', 'Araç Eklenemedi:' . $e->getMessage());
            }


//$this->icu($request);


        } else {
            return redirect()->back()->with('errors', 'İşlem başarısız');
        }


    }


    function karacsil(Request $request)
    {
        DB::table('kiralik_arac')->where('id', $request->id)->delete();
        return redirect()->back()->with('success', 'Kayıt Silindi');
    }

    function taracduzenleup(Request $request)
    {

        $img = null;
        if ($request->hasFile('img')) {

            try {
                $file = $request->file('img');

                if ($file->isValid() && strpos($file->getMimeType(), 'image/') === 0) {
                    $imageName = time() . '.' . $file->getClientOriginalExtension();
                    $file->move(public_path('img'), $imageName);
                    $img = 'img/' . $imageName;
                }


            } catch (\Exception $e) {
                return redirect()->back()->with('errors', 'Araç Eklenemedi:' . $e->getMessage());
            }

        }

        DB::table('transfer_arac')->where('id', $request->id) // Örneğin id değeri ile belirtilen bir satırı güncelleme
        ->update(['isim' => $request->isim, 'tip' => $request->tip, 'model' => $request->model, 'yakit' => $request->yakit, 'cekis' => $request->cekis, 'yolcu' => $request->yolcu, 'bagaj' => $request->bagaj, 'kapi' => $request->kapi, 'acilis' => $request->acilis, 'km' => $request->km, 'img' => $img !== null ? $img : DB::raw('img') // Eğer $img null değilse, $img'i güncellemeye dahil et; aksi takdirde mevcut img değerini koru
        ]);


        return redirect()->back()->with('success', 'Araç Eklendi');


    }

    function musteriduzenle(Request $request)
    {
        $musteri = DB::table('users')->where('rol', 'musteri')->where('id', $request->id)->first();
        if (isset($musteri)) {
            return view('admin.musteriduzenle', compact('request', 'musteri'));
        } else {
            return redirect('/admin');
        }
    }

    function adminduzenle(Request $request)
    {
        $musteri = DB::table('users')->where('rol', 'admin')->where('id', $request->id)->first();
        if (isset($musteri)) {
            return view('admin.adminduzenle', compact('request', 'musteri'));
        } else {
            return redirect('/admin');
        }
    }

    function adminekleup(Request $request)
    {
        DB::table('users')->insert(['rol' => 'admin', 'name' => $request->name, 'email' => $request->email, 'password' => $request->password]);
        return redirect()->back()->with('success', 'Eklendi');
    }

    function adminsilup(Request $request)
    {
        DB::table('users')->where('id', $request->id)->delete();
        return redirect()->back()->with('success', 'Silindi');
    }

    function adminduzenleup(Request $request)
    {

        if (isset($request->sifre)) {

            DB::table('users')->where('id', $request->id)->update(['name' => $request->name, 'email' => $request->email, 'telefon' => $request->telefon, 'password' => $request->sifre]);
        } else {

            DB::table('users')->where('id', $request->id)->update(['name' => $request->name, 'email' => $request->email, 'telefon' => $request->telefon]);

        }

        return redirect()->back()->with('success', 'Güncellendi');
    }

    function musteriduzenleup(Request $request)
    {

        DB::table('users')->where('id', $request->id)->update(['name' => $request->name, 'email' => $request->email, 'telefon' => $request->telefon]);
        return redirect()->back()->with('success', 'Güncellendi');

    }

    function musterisil(Request $request)
    {
        DB::table('users')->where('rol', 'musteri')->where('id', $request->id)->delete();
        return redirect()->back()->with('success', 'Silindi');

    }

    function musteridurum(Request $request)
    {

        DB::table('users')->where('rol', 'musteri')->where('id', $request->id)->update(['aktif' => $request->durum]);
        return redirect()->back()->with('success', 'Aktiflik Durumu değiştirildi');

    }

    function ayarlar(Request $request)
    {
        $ayar = DB::table('ayar')->orderBy('ayargrubu', 'asc');
        if (isset($request->tip)) {
            $ayar->where('ayargrubu', $request->tip);
        }
        $ayar = $ayar->get();
        return view('admin.ayar', compact('request', 'ayar'));
    }

    function ayarlarup(Request $request)
    {

        $formData = $request->all();
        foreach ($formData as $key => $value) {


            try {
                if (is_numeric($key)) {
                    DB::table('ayar')->where('id', $key)->update(['deger' => $value]);
                }
            } catch (Exception $exception) {
                DB::table('hata')->insert(['hata' => $exception->getMessage()]);
            }


        }

        return redirect()->back()->with('success', 'Ayarlar kaydedildi');
    }

    function hesapnumaralari(Request $request)
    {
        $hesapno = DB::table('hesapno')->orderBy('bankaadi', 'asc')->get();
        return view('admin.hesapno', compact('request', 'hesapno'));
    }

    function blog(Request $request)
    {
        $blog = DB::table('blog')->orderBy('id', 'desc')->paginate(200);
        return view('admin.blog', compact('request', 'blog'));

    }

    function isemri(Request $request)
    {
        $isemri = DB::table('transfer')->select('transfer.id as transfer_id', 'users.id as user_id', 'transfer.*', 'users.*')->join('users', 'transfer.username', '=', 'users.id')->where('transfer.id', $request->id)->first();


        return view('admin.isemri', compact('request', 'isemri'));
    }


    function admins(Request $request)
    {
        $admins = DB::table('users')->where('rol', 'admin')->get();
        return view('admin.admins', compact('request', 'admins'));
    }

    function kasa(Request $request, $mod)
    {
        $kasa = DB::table('kasa');
        if ($mod == "giren") {
            $kasa->where('tutar', '>', 0);
        }
        if ($mod == "cikan") {
            $kasa->where('tutar', '<', 0);
        }

        $kasa = $kasa->paginate('1000');

        return view('admin.kasa', compact('request', 'kasa'));
    }

    function ttalepsil(Request $request)
    {
        DB::table('transfer')->where('id', $request->id)->delete();
        return redirect()->back()->with('success', "İptal Edildi");
    }

    function ktalepsil(Request $request)
    {
        DB::table('kiralama')->where('kid', $request->id)->delete();
        return redirect()->back()->with('success', "İptal Edildi");
    }

    function turlar(Request $request)
    {
        $kat = DB::table('turkat')->get();


        $tur = DB::table('turlar')
            ->join('turkat', 'turlar.katid', '=', 'turkat.id')
            ->select('turlar.id as turlar_id', 'turlar.*', 'turkat.*')
            ->get();


        return view('admin.turlar', compact('request', 'kat', 'tur'));
    }


    function turekle(Request $request)
    {

        $img = null;
        if ($request->hasFile('img')) {

            try {
                $file = $request->file('img');

                if ($file->isValid() && strpos($file->getMimeType(), 'image/') === 0) {
                    $imageName = time() . '.' . $file->getClientOriginalExtension();
                    $file->move(public_path('img'), $imageName);
                    $img = 'img/' . $imageName;
                }


                DB::table('turlar')
                    ->insert([
                        'baslik' => $request->baslik,
                        'turkisatanim' => $request->turkisatanim,
                        'katid' => $request->katid,
                         'star' => $request->star,
                        'price' => $request->yetiskin,
                        'baslama' => $request->baslama,
                        'bitis' => $request->bitis,
                        'program' => $request->program,
                        'img' => $img,
                        'yetiskin' => $request->yetiskin,
                        'bcocuk' => $request->bcocuk,
                        'kcocuk' => $request->kcocuk,
                        'bebek' => $request->bebek]);

                return redirect()->back()->with('success', 'Tur Eklendi');
            } catch (\Exception $e) {
                return redirect()->back()->with('errors', 'Tur Eklenemedi:' . $e->getMessage());
            }


//$this->icu($request);


        } else {
            return redirect()->back()->with('errors', 'İşlem başarısız');
        }


    }


    function tursil(Request $request)
    {
        DB::table('turlar')->where('id', $request->id)->delete();
        return redirect()->back()->with('success', 'Tur Silindi');
    }


    function turduzenle(Request $request)
    {

        $tur = DB::table('turlar')->where('id', $request->id)->first();
        $kat = DB::table('turkat')->get();
        return view('admin.turduzenle', compact('request', 'tur', 'kat'));

    }


    function turduzenleup(Request $request)
    {

        $img = $request->eskimg;
        if ($request->hasFile('img')) {

            try {
                $file = $request->file('img');

                if ($file->isValid() && strpos($file->getMimeType(), 'image/') === 0) {
                    $imageName = time() . '.' . $file->getClientOriginalExtension();
                    $file->move(public_path('img'), $imageName);
                    $img = 'img/' . $imageName;
                }
            } catch (\Exception $e) {
                return redirect()->back()->with('errors', 'Tur Düzenlendi:' . $e->getMessage());
            }
        }


        DB::table('turlar')
            ->where('id', $request->id)
            ->update([
                'baslik' => $request->baslik,
                'turkisatanim' => $request->turkisatanim,
                'katid' => $request->katid,
                'star' => $request->star,
                'price' => $request->yetiskin,
                'baslama' => $request->baslama,
                'bitis' => $request->bitis,
                'program' => $request->program,
                'img' => $img,
                'yetiskin' => $request->yetiskin,
                'bcocuk' => $request->bcocuk,
                'kcocuk' => $request->kcocuk,
                'bebek' => $request->bebek]);

        return redirect()->back()->with('success', 'Tur Düzenlendi');


//$this->icu($request);


    }

    function turkategorileri(Request$request)
    {

        $kat=DB::table('turkat')->get();
        return view('admin.turkat',compact('request','kat'));

    }

    function turtalepiptal(Request$request)
    {

        DB::table('tursip')->where('id',$request->id)->delete();
        return redirect()->back()->with('success','Silindi');
    }

    function ekhizmet(Request$request)
    {
        $ekhizmet=DB::table('ekhizmet')->get();
        return view('admin.ekhizmet',compact('request','ekhizmet'));
    }

    function hizmetekle(Request$request)
    {
        $ucret=(float)$request->ucret;

        DB::table('ekhizmet')->insert(['hizmet'=>$request->hizmet,'ucret'=>$ucret]);
        return redirect()->back()->with('success','Eklendi');
    }

    function ekhizmetsil(Request$request)
    {
        DB::table('ekhizmet')->where('id',$request->id)->delete();
        return redirect()->back()->with('success','Silindi');
    }

}
