<?php

namespace App\Http\Controllers;

use App\Mail\hosgeldiniz;
use App\Mail\resetmail;
use App\Mail\sifremiunuttum;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Str;
use ZipArchive;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\File;
use RecursiveIteratorIterator;
use RecursiveDirectoryIterator;


class gencbeyin extends Controller
{

    public function __construct()
    {
        $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
        if (session()->get('pb')==null)
        {
            session()->put('pb',$ayar['pb']);
        }
    }

    public function main(Request $request)
    {

        $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
        $doviz = DB::table('kur')->pluck('oran', 'pb');


        $pb=$request->session()->get('pb');
        if ($pb=="")
        {
            $pb=@auth()->user()->pb;
        }

        if ($pb=="")
        {
            $pb=$ayar['pb'];
        }

        $request->session()->put('pb',$pb);



        $kur=DB::table('kur')->where('tarih','like',date('Y-m-d')."%")->count();
        if ($kur==0)
        {
            try {
                $this->kur();
            }
            catch (Exception $e)
            {
                die($e->getMessage()." Kurlar alınamadı.");
            }


        }


        $transkat = DB::table('transfer_kategori')->get();

        $linkler = DB::table('linkler')->orderBy('id', 'asc')->get();
        $kiralik = DB::table('kiralik_arac')->orderBy('ucret360', 'asc')->paginate(10);
        $sss = DB::table('sss')->get();
        $blog = DB::table('blog')->orderBy('id', 'desc')->paginate(3);
        return view('anasayfa', compact('request', 'ayar', 'transkat', 'linkler', 'kiralik', 'sss', 'blog','doviz'));
    }

    function logout(Request $request)
    {
        auth()->logout();
        return redirect('/');
    }


    function login(Request $request)
    {


        $referer = $request->headers->get('referer');
        $transkat = DB::table('transfer_kategori')->get();
        $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
        $linkler = DB::table('linkler')->orderBy('id', 'asc')->get();

        return view('login', compact('request', 'transkat', 'ayar', 'linkler'));
    }

    function sifremiunuttum(Request $request)
    {
        $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
        $linkler = DB::table('linkler')->orderBy('id', 'asc')->get();
        return view('sifremiunuttum', compact('request', 'ayar', 'linkler'));
    }

    function sifresifirla(Request $request)
    {
        $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
        $uyebilgi = DB::table('users')->where('email', $request->email)->first();
        if (isset($uyebilgi)) {
            $resettoken = md5($uyebilgi->email . rand(0, 9999999999));
            DB::table('users')->where('id', $uyebilgi->id)->update(['resettoken' => $resettoken]);

            $uyebilgi = DB::table('users')->where('email', $request->email)->first();


            $domain = $request->getHost();

            $mail = new sifremiunuttum();
            $mail->to($uyebilgi->email, $uyebilgi->name);
            $mail->from($ayar['mail'], $ayar['siteadi']);
            $mail->subject('Şifre Sıfırlama');
            $mail->with('uyebilgi', $uyebilgi);
            $mail->with('domain', $domain);
            $mail->attach(public_path('/images/logo.png'));
//            $mail->attach('/yol/dosya2.png', ['as' => 'resim.png']);
//       //        \Mail::send($mail);


            return redirect('/')->with('success', 'Şifrenizi sıfırlamak için gerekli olan link e-posta adresinize gönderildi');
        } else {
            return redirect()->back()->with('errors', 'Şifreniz sıfırlanamaz');
        }

    }

    function generateRandomPassword()
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $passwordLength = mt_rand(6, 8);
        $password = '';

        $charactersLength = strlen($characters);
        for ($i = 0; $i < $passwordLength; $i++) {
            $password .= $characters[mt_rand(0, $charactersLength - 1)];
        }

        return $password;
    }

    function resetmail(Request $request)
    {
        $reset = DB::table('users')->where('resettoken', $request->token)->first();
        if (isset($reset)) {


            $sifre = $this->generateRandomPassword();


            DB::table('users')->where('id', $reset->id)->update(['resettoken' => null, 'password' => $sifre]);

            $uyebilgi = DB::table('users')->where('id', $reset->id)->first();

            $mail = new resetmail();
            $mail->to($uyebilgi->email, $uyebilgi->name);
            $mail->subject('Yeni Şifreniz');
            $mail->with('uyebilgi', $uyebilgi);
//           $mail->attach(public_path('/images/logo.png'));
//            $mail->attach('/yol/dosya2.png', ['as' => 'resim.png']);
            //        \Mail::send($mail);


            return redirect('/')->with('success', 'Yeni şifreniz e-mail adresinize gönderildi.');

        } else {
            return redirect('/')->with('errors', 'Link geçerli değil, şifreniz sıfırlanamaz');
        }
    }

    function transferara(Request $request)
    {

// Google Maps API isteği için gerekli olan API anahtarınızı buraya ekleyin
        $apiKey = 'AIzaSyCtEhG782wJXqrmFmTFGoVFd_zFK2SgS0A';


        try {

            $originAddress = urlencode($request->input('alinmanoktasi'));
            $destinationAddress = urlencode($request->input('birakilmanoktasi'));

            // Origin ve destination adreslerini Google Maps API'ya göndererek koordinatları alın
            $client = new Client();
            $geocodeUrl = "https://maps.googleapis.com/maps/api/geocode/json?address=";
            $originResponse = $client->get($geocodeUrl . $originAddress . "&key=" . $apiKey);
            $originData = json_decode($originResponse->getBody(), true);
            $originCoords = $originData['results'][0]['geometry']['location'];

            $destinationResponse = $client->get($geocodeUrl . $destinationAddress . "&key=" . $apiKey);
            $destinationData = json_decode($destinationResponse->getBody(), true);
            $destinationCoords = $destinationData['results'][0]['geometry']['location'];

            $origin = $originCoords['lat'] . ',' . $originCoords['lng'];
            $destination = $destinationCoords['lat'] . ',' . $destinationCoords['lng'];

            // Mesafeyi hesaplamak için Google Maps Distance Matrix API kullanın
            $distanceUrl = "https://maps.googleapis.com/maps/api/distancematrix/json?origins=" . $origin . "&destinations=" . $destination . "&key=" . $apiKey;
            /* echo $distanceUrl;*/
            $distanceResponse = $client->get($distanceUrl);
            $distanceData = json_decode($distanceResponse->getBody(), true);
            $distance = $distanceData['rows'][0]['elements'][0]['distance']['value'];

            // Diğer veritabanı sorguları ve işlemleri devam eder...
            $transkat = DB::table('transfer_kategori')->get();
            $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
            $linkler = DB::table('linkler')->orderBy('id', 'asc')->get();

            // Mesafeyi kilometreye dönüştürün ve yuvarlayın
            $distance = ceil($distance / 1000);

            $alinmatarihi = Carbon::createFromDate($request->alinmatarihi)->format('Y-m-d') . " " . $request->alinmasaati;
            $birakilmatarihi = Carbon::createFromDate($request->birakilmatarihi)->format('Y-m-d') . " " . $request->alinmasaati;

            $transferid = DB::table('transfer')->insertGetId([

                'alinmanoktasi' => $request->alinmanoktasi, 'birakilmanoktasi' => $request->birakilmanoktasi, 'birakilmatarihi' => $birakilmatarihi, 'alinmatarihi' => $alinmatarihi, 'distance' => $distance, 'origin' => $origin, 'username' => auth()->user()->id ?? null, 'destination' => $destination, 'tarih' => date('Y-m-d H:i:s'), 'durum' => 'Sorgulandı',]);

            $arac = DB::table('transfer_arac')->orderBy('km', 'asc')->where('aktif', 1);

            if (isset($request->arac)) {
                $arac->where('id', $request->arac);
            }

            $arac = $arac->paginate(100);

            $doviz = DB::table('kur')->pluck('oran', 'pb');

            if ($distance == 0) {
                return redirect()->back()->with('errors', 'Adresleri daha detaylı girmeniz durumuda teklif verilebilecektir.');
            } else {

                $alinmanoktasi = $request->alinmanoktasi;
                $birakilmanoktasi = $request->birakilmanoktasi;


                return view('sonuc', compact('doviz','distance', 'request', 'destination', 'origin', 'transkat', 'ayar', 'linkler', 'arac', 'transferid', 'alinmanoktasi', 'birakilmanoktasi', 'originCoords', 'destinationCoords'));
            }
        } catch (Exception $e) {
            DB::table('hata')->insert(['hata' => $e->getMessage(), 'kod' => $e->getCode()]);
            return redirect()->back()->with('errors', 'Alınma ve/veya bırakılma noktalarında hata var. Adresleri tekrar deneyin.');
        }


    }

    public function transferarabing(Request $request)
    {


//        $veriler = $request->all();
//        foreach ($veriler as $key => $value) {
//            echo $key . ': ' . $value . '<br>';
//        }
//        die();


        $transkat = DB::table('transfer_kategori')->get();
        $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
        $linkler = DB::table('linkler')->orderBy('id', 'asc')->get();

        $ayar = DB::table('ayar')->pluck('deger', 'anahtar');

        $distance = 0;


        $apiKey = $ayar['googlemapsgooglemaps'];


        try {

            $originAddress = urlencode($request->input('alinmanoktasi'));
            $destinationAddress = urlencode($request->input('birakilmanoktasi'));


            $geocodeUrl = "https://dev.virtualearth.net/REST/v1/Locations?query=";
            $distanceUrl = "https://dev.virtualearth.net/REST/v1/Routes/DistanceMatrix?origins=%s&destinations=%s&travelMode=driving&key=%s";

            $client = new Client();

            // Origin Adresini Koordinatlara Dönüştürme
            $response = $client->get($geocodeUrl . $originAddress . "&key=" . $apiKey);
            $data = json_decode($response->getBody(), true);

            $originCoords = $data['resourceSets'][0]['resources'][0]['point']['coordinates'];
            $origin = $originCoords[0] . ',' . $originCoords[1];

            // Destination Adresini Koordinatlara Dönüştürme
            $response = $client->get($geocodeUrl . $destinationAddress . "&key=" . $apiKey);
            $data = json_decode($response->getBody(), true);

            $destinationCoords = $data['resourceSets'][0]['resources'][0]['point']['coordinates'];
            $destination = $destinationCoords[0] . ',' . $destinationCoords[1];

            // Mesafeyi Hesaplama
            $url = sprintf($distanceUrl, $origin, $destination, $apiKey);

            $response = $client->get($url);
            $data = json_decode($response->getBody(), true);

            $distance = $data['resourceSets'][0]['resources'][0]['results'][0]['travelDistance'];
        } catch (Exception $e) {
            DB::table('hata')->insert(['hata' => $e->getMessage(), 'kod' => $e->getCode()]);
            return redirect()->back()->with('errors', 'Alınma ve/veya bırakılma noktalarında hata var. adresleri tekrar deneyin.');
        }

        $username = null;
        if (isset(auth()->user()->id)) {
            $username = auth()->user()->id;
        }

        $distance = ceil($distance);

        $alinmatarihi = Carbon::createFromDate($request->alinmatarihi)->format('Y-m-d') . " " . $request->alinmasaati;
        $birakilmatarihi = Carbon::createFromDate($request->birakilmatarihi)->format('Y-m-d') . " " . $request->alinmasaati;

        $transferid = DB::table('transfer')->insertGetId(['aractipi' => $request->aractipi, 'alinmanoktasi' => $request->alinmanoktasi, 'birakilmanoktasi' => $request->birakilmanoktasi, 'birakilmatarihi' => $birakilmatarihi, 'alinmatarihi' => $alinmatarihi, 'distance' => $distance, 'origin' => $origin, 'username' => $username, 'destination' => $destination, 'tarih' => date('Y-m-d H:i:s'), 'durum' => 'Sorgulandı',

        ]);

        $arac = DB::table('transfer_arac')->orderBy('km', 'asc')->where('aktif', 1);

        if (isset($request->arac)) {
            $arac->where('id', $request->arac);
        }


        $arac = $arac->paginate(100);


        if ($distance == 0) {
            return redirect()->back()->with('errors', 'Adresleri daha detaylı girmeniz durumuda teklif verilebilecektir.');

        } else {

            return view('sonuc', compact('distance', 'request', 'destination', 'origin', 'transkat', 'ayar', 'linkler', 'arac', 'transferid'));
        }

    }

    function uyeol(Request $request)
    {
        $transkat = DB::table('transfer_kategori')->get();
        $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
        $linkler = DB::table('linkler')->orderBy('id', 'asc')->get();
        return view('uyeol', compact('request', 'transkat', 'ayar', 'linkler'));
    }

    function uyeolup(Request $request)
    {
        $mail = DB::table('users')->where('email', $request->email)->count();
        if ($mail > 0) {
            return redirect()->back()->with('errors', 'Bu email kullanılarak daha önce üye olunmuş');
        } else {
            $loginid = DB::table('users')->insertGetId(['name' => $request->name, 'email' => $request->email, 'telefon' => $request->telefon, 'password' => $request->password, 'utarih' => date('Y-m-d')]);


            auth()->loginUsingId($loginid);


            $uyebilgi = DB::table('users')->where('id', auth()->id())->first();

            $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
            $mail = new hosgeldiniz();
            $mail->to(auth()->user()->email, auth()->user()->name);
            $mail->from($ayar['mail'], $ayar['siteadi']);
            $mail->subject('Üyeliğiniz Tamamlandı');
            $mail->with('isim', auth()->user()->name);
            $mail->with('uyebilgi', $uyebilgi);
            $mail->attach(public_path('/images/logo.png'));
//            $mail->attach('/yol/dosya2.png', ['as' => 'resim.png']);
            //        \Mail::send($mail);


            return redirect('/panel')->with('success', 'Hoşgeldiniz, üyeliğiniz oluşturuldu.');

        }
    }


    function restore(Request $request)
    {
        // Tüm tabloları sil
        Artisan::call('migrate:reset');

// Yedek dosyasının yolu
        $yedekDosyasi = public_path('yedek.sql');

// Yedek dosyasının varlığını kontrol et
        if (File::exists($yedekDosyasi)) {
            // Yedek dosyasını içeri aktar
            $sql = file_get_contents($yedekDosyasi);
            DB::unprepared($sql);
        } else {
            // Yedek dosyası bulunamadı
            echo 'Yedek dosyası bulunamadı: ' . $yedekDosyasi;
        }


        return redirect('/');

    }

    function backup(Request $request)
    {

        $username = env('DB_USERNAME');
        $password = env('DB_PASSWORD');
        $host = env('DB_HOST');
        $database = env('DB_DATABASE');

        $tables = DB::select('SHOW TABLES');

        $backup_file = 'yedek.sql';
        $command = "mysqldump --user={$username} --password={$password} --host={$host} {$database} ";

        foreach ($tables as $table) {
            $table = (array)$table;
            $table_name = reset($table);
            $command .= "{$table_name} ";
        }

        $command .= "> {$backup_file}";
        exec($command);


        $file_path = 'yedek.sql';
        $zip_file_path = 'yedek.zip';
        $recipient = 'muratersoy@gmail.com';

// Dosya zipleyin
        $zip = new ZipArchive();
        $zip->open($zip_file_path, ZipArchive::CREATE | ZipArchive::OVERWRITE);
        $zip->addFile($file_path, basename($file_path));
        $zip->close();


// Mail gönderin
        Mail::raw('Dosya ektedir', function ($message) use ($zip_file_path, $recipient) {
            $message->to($recipient);
            $message->subject('TransferPro Dosya gönderimi ' . date('d/m/Y H:i'));
            $message->attach($zip_file_path, ['as' => 'yedek.zip', 'mime' => 'application/zip',]);
        });

        //  @unlink('yedek.sql');
        @unlink('yedek.zip');

        //$this->cronokulisim();

        return redirect('/');
    }


    function loginup(Request $request)
    {
        if (isset($request->email) && isset($request->password)) {


            $uye = DB::table('users')->where('email', $request->email)->where('password', $request->password)->where('aktif', '1')->first();

            if (isset($uye->id)) {
                auth()->loginUsingId($uye->id);
                if ($uye->rol == "admin") {
                    return redirect('/admin');
                } else {
                    return redirect('/panel');
                }
            } else {
                return redirect()->back()->with('errors', 'Giriş sağlanamadı.');
            }

        } else {


            return redirect()->back()->with('errors', 'Giriş Bilgileri Eksik');

        }
    }


    function profilduzenle(Request $request)
    {

        $validatedData = $request->validate(['name' => 'required', 'email' => 'required|email', 'telefon' => 'required',]);

        // Doğrulama başarılı ise, form verilerini kullanabilirsiniz
        if (empty($validatedData)) {
            return redirect()->back()->with('errors', 'Bilgilerde eksik / yanlış var');
        } else {

            DB::table('users')->where('id', auth()->user()->id)->update(['name' => $request->name, 'email' => $request->email, 'telefon' => $request->telefon]);
            return redirect()->back()->with('success', 'Bilgileriniz Güncellendi');
        }


    }

    function panel(Request $request, $alt = "")
    {


        if (auth()->check()) {
            $transkat = DB::table('transfer_kategori')->get();
            $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
            $linkler = DB::table('linkler')->orderBy('id', 'asc')->get();
            $uye = DB::table('users')->where('id', auth()->id())->first();
            $transfer = DB::table('transfer')->where('username', auth()->user()->id)->orderBy('id', 'desc')->paginate(50);
            $kiralama = DB::table('kiralama')->join('kiralik_arac', 'kiralama.aracid', '=', 'kiralik_arac.id')->join('users', 'kiralama.userid', '=', 'users.id')->where('userid', auth()->user()->id)->orderBy('kid', 'desc')->paginate(50);


            return view('panel', compact('request', 'transkat', 'ayar', 'linkler', 'uye', 'transfer', 'alt', 'kiralama'));
        } else {
            return redirect('/login');
        }

    }

    function araclar(Request $request)
    {
        $transkat = DB::table('transfer_kategori')->get();
        $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
        $linkler = DB::table('linkler')->orderBy('id', 'asc')->get();
        $kiralik = DB::table('kiralik_arac')->orderBy('ucret360', 'asc')->paginate(100);


        $doviz = DB::table('kur')->pluck('oran', 'pb');


        return view('rentacar', compact('request', 'transkat', 'ayar', 'linkler', 'kiralik','doviz'));
    }

    function transfer(Request $request)
    {
        $transkat = DB::table('transfer_kategori')->get();
        $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
        $linkler = DB::table('linkler')->orderBy('id', 'asc')->get();
        $arac = DB::table('transfer_arac')->orderBy('km', 'asc')->where('aktif', 1)->paginate(100);



        $doviz = DB::table('kur')->pluck('oran', 'pb');


        return view('transfer', compact('request', 'transkat', 'ayar', 'linkler', 'arac','doviz'));
    }

    function rezervasyon(Request $request)
    {
        $transkat = DB::table('transfer_kategori')->get();
        $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
        $linkler = DB::table('linkler')->orderBy('id', 'asc')->get();
        $arac = DB::table('transfer_arac')->where('id', $request->arac)->first();
        DB::table('transfer')->where('username', auth()->user()->id)->where('id', $request->sorgu)->update(['arac' => $request->arac]);
        $transfer = DB::table('transfer')->where('id', $request->sorgu)->first();

        $doviz = DB::table('kur')->pluck('oran', 'pb');

        $ekhizmet=DB::table('ekhizmet')->get();





        $miktar=(($arac->km*$transfer->distance)+$arac->acilis);

        return view('rezervasyon', compact('ekhizmet','transkat', 'ayar', 'linkler', 'arac', 'transfer', 'request','doviz','miktar'));

    }

    function blog(Request $request)
    {
        $blog = "içerik";
        $transkat = DB::table('transfer_kategori')->get();
        $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
        $linkler = DB::table('linkler')->orderBy('id', 'asc')->get();
        $blog = DB::table('blog')->orderBy('id', 'desc')->paginate(100);
        return view('blog', compact('request', 'transkat', 'ayar', 'linkler', 'blog'));

    }

    function iletisim(Request $request)
    {
        $transkat = DB::table('transfer_kategori')->get();
        $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
        $linkler = DB::table('linkler')->orderBy('id', 'asc')->get();
        return view('iletisim', compact('request', 'transkat', 'ayar', 'linkler'));
    }

    function send(Request $request)
    {
        return redirect()->back()->with('success', 'Mesajınız alındı, ilginize teşekkürler.');
    }

    function odeme(Request $request)
    {
        $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
        $linkler = DB::table('linkler')->orderBy('id', 'asc')->get();
        return view('odeme', compact('request', 'ayar', 'linkler'));
    }



//    PAYTR FUNCS
//    PAYTR FUNCS
    public function odemeekrani()
    {
        return view("odeme");
    }

    public function paytr(Request $request)
    {

        $doviz = DB::table('kur')->pluck('oran', 'pb');

        $ayar = DB::table('ayar')->pluck('deger', 'anahtar');


        if ($request->has('ekhizmet')) {
            // Seçili olan checkbox değerlerini alıyoruz
            $selectedValues = $request->input('ekhizmet');

            // Diziyi birleştirerek string haline getiriyoruz
            $ekhizmetler = implode(',', $selectedValues);

            // Ekrana yazdırabilirsiniz veya başka bir amaç için kullanabilirsiniz

        }


        try {
            DB::table('transfer')->where('id',$request->sorgu)->update(['ekhizmet'=>$ekhizmetler]);
        }
        catch (Exception $e)
        {
            //echo $e->getMessage();
        }


        if ($request->tip=="transfer")
        {
            $miktar=$request->miktar;
            $miktar=explode('|',$miktar);
            if ($miktar[0]=="Tek")
            {
                $katsayi=1;
                $yon="Tek";
            }
            else
            {
                $katsayi=1.75;
                $yon="Çift";
            }




            $transfer=DB::table('transfer')->where('id',$request->sorgu)->first();
            $arac=DB::table('transfer_arac')->where('id',$request->arac)->first();



            $miktar=(($arac->km*$transfer->distance)+$arac->acilis)*$katsayi;

            $ekhizmetler=explode(',',$ekhizmetler);

            foreach ($ekhizmetler as $item)
            {
              $eh=DB::table('ekhizmet')->where('id',$item)->first();
                $miktar=$miktar+$eh->ucret;
            }



            $doviz = DB::table('kur')->pluck('oran', 'pb');

            $miktar=$miktar*$doviz[$ayar['pb']];



        }











        if ($request->tip=="kiralama") {
            try {



                $kapora = $ayar['kapora'];
                $kapora_sadece_sayi = preg_replace("/[^0-9]/", "", $kapora);
                $kapora_sadece_sayi = (int)$kapora_sadece_sayi;
                $kapora = $kapora_sadece_sayi;

                $miktar = $kapora*$doviz[$ayar['pb']];

                $durum = "Ödeme Bekliyor";
//                echo $request->id;
//                echo "<br>";
//                echo $request->alinma;
//                echo "<br>";
//                echo $request->birakilma;
//                echo "<br>";
                $userid = auth()->user()->id;
                DB::table('kiralama')->insertGetId(['userid' => $userid, 'aracid' => $request->id, 'alinma' => $request->alinma, 'birakilma' => $request->birakilma, 'durum' => $durum, 'tarih' => date('Y-m-d H:i:s')]);


            } catch (Exception $e) {
                echo $e->getMessage();
                die();
            }

        }
        if ($request->tip=="tur") {
            try {



            $miktar=$request->miktar;



            } catch (Exception $e) {
                echo $e->getMessage();
                die();
            }

        }



        if ($request->tur=="transfer") {
            $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
            DB::table('transfer')->where('id', $request->sorgu)->where('username', auth()->user()->id)->update(['havalebanka' => -1, 'yon' => $yon]);
        }

        $data = request()->all();







        ## 1. ADIM için örnek kodlar ##

        ####################### DÜZENLEMESİ ZORUNLU ALANLAR #######################
        #
        ## API Entegrasyon Bilgileri - Mağaza paneline giriş yaparak BİLGİ sayfasından alabilirsiniz.

        $merchant_id = $ayar['paytrid'];

        $merchant_key = $ayar['paytrkey'];

        $merchant_salt = $ayar['paytrsalt'];

        if (!isset($random_id)) {
            $random_id = "11" . rand(1, 999) . rand(1, 88) * rand(1, 50);
        }
        #
        ## Müşterinizin sitenizde kayıtlı veya form vasıtasıyla aldığınız eposta adresi
        $email = auth()->user()->email;
        #
        ## Tahsil edilecek tutar.
        $payment_amount = $miktar * 100; //9.99 için 9.99 * 100 = 999 gönderilmelidir.
        #
        ## Sipariş numarası: Her işlemde benzersiz olmalıdır!! Bu bilgi bildirim sayfanıza yapılacak bildirimde geri gönderilir.
        $merchant_oid = $random_id;
        #
        ## Müşterinizin sitenizde kayıtlı veya form aracılığıyla aldığınız ad ve soyad bilgisi
        $user_name = auth()->user()->name;
        #
        ## Müşterinizin sitenizde kayıtlı veya form aracılığıyla aldığınız adres bilgisi
        $user_address = "xxxxxxx";
        #
        ## Müşterinizin sitenizde kayıtlı veya form aracılığıyla aldığınız telefon bilgisi
        $user_phone = auth()->user()->telefon;
        #
        ## Başarılı ödeme sonrası müşterinizin yönlendirileceği sayfa
        ## !!! Bu sayfa siparişi onaylayacağınız sayfa değildir! Yalnızca müşterinizi bilgilendireceğiniz sayfadır!
        ## !!! Siparişi onaylayacağız sayfa "Bildirim URL" sayfasıdır (Bakınız: 2.ADIM Klasörü).
        $merchant_ok_url = "https://transferpro.ucretsizscript.net/payment-ok";
        #
        ## Ödeme sürecinde beklenmedik bir hata oluşması durumunda müşterinizin yönlendirileceği sayfa
        ## !!! Bu sayfa siparişi iptal edeceğiniz sayfa değildir! Yalnızca müşterinizi bilgilendireceğiniz sayfadır!
        ## !!! Siparişi iptal edeceğiniz sayfa "Bildirim URL" sayfasıdır (Bakınız: 2.ADIM Klasörü).
        $merchant_fail_url = "https://transferpro.ucretsizscript.net/payment-failed";
        #
        ## Müşterinin sepet/sipariş içeriği
        $user_basket = base64_encode(json_encode(array(array("Havalanı transfer rezervasyonu", $payment_amount, 1))));


        #
        /* ÖRNEK $user_basket oluşturma - Ürün adedine göre array'leri çoğaltabilirsiniz
        $user_basket = base64_encode(json_encode(array(
            array("Örnek ürün 1", "18.00", 1), // 1. ürün (Ürün Ad - Birim Fiyat - Adet )
            array("Örnek ürün 2", "33.25", 2), // 2. ürün (Ürün Ad - Birim Fiyat - Adet )
            array("Örnek ürün 3", "45.42", 1)  // 3. ürün (Ürün Ad - Birim Fiyat - Adet )
        )));
        */ ############################################################################################

        ## Kullanıcının IP adresi
        if (isset($_SERVER["HTTP_CLIENT_IP"])) {
            $ip = $_SERVER["HTTP_CLIENT_IP"];
        } elseif (isset($_SERVER["HTTP_X_FORWARDED_FOR"])) {
            $ip = $_SERVER["HTTP_X_FORWARDED_FOR"];
        } else {
            $ip = $_SERVER["REMOTE_ADDR"];
        }

        ## !!! Eğer bu örnek kodu sunucuda değil local makinanızda çalıştırıyorsanız
        ## buraya dış ip adresinizi (https://www.whatismyip.com/) yazmalısınız. Aksi halde geçersiz paytr_token hatası alırsınız.
        $user_ip = $ip;
        ##

        ## İşlem zaman aşımı süresi - dakika cinsinden
        $timeout_limit = "5";

        ## Hata mesajlarının ekrana basılması için entegrasyon ve test sürecinde 1 olarak bırakın. Daha sonra 0 yapabilirsiniz.
        $debug_on = 1;

        ## Mağaza canlı modda iken test işlem yapmak için 1 olarak gönderilebilir.
        $test_mode = 0;

        $no_installment = 1; // Taksit yapılmasını istemiyorsanız, sadece tek çekim sunacaksanız 1 yapın

        ## Sayfada görüntülenecek taksit adedini sınırlamak istiyorsanız uygun şekilde değiştirin.
        ## Sıfır (0) gönderilmesi durumunda yürürlükteki en fazla izin verilen taksit geçerli olur.
        $max_installment = 0;

        $currency = "TL";

        ####### Bu kısımda herhangi bir değişiklik yapmanıza gerek yoktur. #######
        $hash_str = $merchant_id . $user_ip . $merchant_oid . $email . $payment_amount . $user_basket . $no_installment . $max_installment . $currency . $test_mode;
        $paytr_token = base64_encode(hash_hmac('sha256', $hash_str . $merchant_salt, $merchant_key, true));
        $data_vals = array('merchant_id' => $merchant_id, 'user_ip' => $user_ip, 'merchant_oid' => $merchant_oid, 'email' => $email, 'payment_amount' => $payment_amount, 'paytr_token' => $paytr_token, 'user_basket' => $user_basket, 'debug_on' => $debug_on, 'no_installment' => $no_installment, 'max_installment' => $max_installment, 'user_name' => $user_name, 'user_address' => $user_address, 'user_phone' => $user_phone, 'merchant_ok_url' => $merchant_ok_url, 'merchant_fail_url' => $merchant_fail_url, 'timeout_limit' => $timeout_limit, 'currency' => $currency, 'test_mode' => $test_mode);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://www.paytr.com/odeme/api/get-token");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_vals);
        curl_setopt($ch, CURLOPT_FRESH_CONNECT, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 20);

        // XXX: DİKKAT: lokal makinanızda "SSL certificate problem: unable to get local issuer certificate" uyarısı alırsanız eğer
        // aşağıdaki kodu açıp deneyebilirsiniz. ANCAK, güvenlik nedeniyle sunucunuzda (gerçek ortamınızda) bu kodun kapalı kalması çok önemlidir!
        // curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

        $result = @curl_exec($ch);

        if (curl_errno($ch)) die("PAYTR IFRAME connection error. err:" . curl_error($ch));

        curl_close($ch);

        $result = json_decode($result, 1);

        if ($result['status'] == 'success') {
            $token = $result['token'];
        } else {

            $this->log($result['reason']);
            abort(500);
        }

        $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
        $linkler = DB::table('linkler')->orderBy('id', 'asc')->get();

        return view("odeme-sonuc", compact('token', 'ayar', 'linkler'));


    }

    function log($hata)
    {
        DB::table('hata')->insert(['hata' => $hata]);
    }

    public function bildirim()
    {
        $data = request()->all();
        ####################### DÜZENLEMESİ ZORUNLU ALANLAR #######################
        ## API Entegrasyon Bilgileri - Mağaza paneline giriş yaparak BİLGİ sayfasından alabilirsiniz.

        $merchant_key = 'xxxxxxx';
        $merchant_salt = 'xxxxxxx';

        ###########################################################################

        ####### Bu kısımda herhangi bir değişiklik yapmanıza gerek yoktur. #######
        #
        ## POST değerleri ile hash oluştur.
        $hash = base64_encode(hash_hmac('sha256', $data['merchant_oid'] . $merchant_salt . $data['status'] . $data['total_amount'], $merchant_key, true));
        #
        ## Oluşturulan hash'i, paytr'dan gelen post içindeki hash ile karşılaştır (isteğin paytr'dan geldiğine ve değişmediğine emin olmak için)
        ## Bu işlemi yapmazsanız maddi zarara uğramanız olasıdır.
        if ($hash != $data['hash']) die('PAYTR notification failed: bad hash');
        ###########################################################################

        ## BURADA YAPILMASI GEREKENLER
        ## 1) Siparişin durumunu $data['merchant_oid'] değerini kullanarak veri tabanınızdan sorgulayın.
        ## 2) Eğer sipariş zaten daha önceden onaylandıysa veya iptal edildiyse  echo "OK"; exit; yaparak sonlandırın.

        /* Sipariş durum sorgulama örnek
           $durum = SQL
           if($durum == "onay" || $durum == "iptal"){
                echo "OK";
                exit;
            }
         */

        if ($data['status'] == 'success') { ## Ödeme Onaylandı

            ## BURADA YAPILMASI GEREKENLER
            ## 1) Siparişi onaylayın.
            ## 2) Eğer müşterinize mesaj / SMS / e-posta gibi bilgilendirme yapacaksanız bu aşamada yapmalısınız.
            ## 3) 1. ADIM'da gönderilen payment_amount sipariş tutarı taksitli alışveriş yapılması durumunda
            ## değişebilir. Güncel tutarı $data['total_amount'] değerinden alarak muhasebe işlemlerinizde kullanabilirsiniz.

        } else { ## Ödemeye Onay Verilmedi

            ## BURADA YAPILMASI GEREKENLER
            ## 1) Siparişi iptal edin.
            ## 2) Eğer ödemenin onaylanmama sebebini kayıt edecekseniz aşağıdaki değerleri kullanabilirsiniz.
            ## $data['failed_reason_code'] - başarısız hata kodu
            ## $data['failed_reason_msg'] - başarısız hata mesajı

        }

        ## Bildirimin alındığını PayTR sistemine bildir.
        echo "OK";
        exit;

    }
//    PAYTR FUNCS
//    PAYTR FUNCS
    function paymentok(Request $request)
    {
//    to.do admine mail
        $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
        $linkler = DB::table('linkler')->orderBy('id', 'asc')->get();
        return view('payment-ok', compact('request', 'ayar', 'linkler'));

    }

    function odemebildir(Request $request)
    {

        if (isset($request->kid)) {

            DB::table('kiralama')->where('userid', auth()->user()->id)->where('kid', $request->kid)->update(['durum' => 'Havale Onayı Bekliyor', 'banka' => $request->banka, 'tur' => $request->tur]);
            return redirect('/panel/kiralama')->with('success', 'Bildiriminiz Onaya Gönderildi');


        } else {

            if ($request->tur == "sofor") {
                if (DB::table('transfer')->where('username', auth()->user()->id)->where('id', $request->sorgu)->update(['havalebanka' => -3, 'yon' => $request->yon, 'durum' => 'Şoföre Ödenecek'])) {
                    return redirect('/panel/transfer')->with('success', 'Ödeme Seçiminiz Kaydedildi.');
                } else {
                    return redirect('/panel/transfer')->with('errors', 'Bildirim Yapılamadı');
                }
            } else {
                if (DB::table('transfer')->where('username', auth()->user()->id)->where('id', $request->sorgu)->update(['havalebanka' => $request->banka, 'yon' => $request->yon])) {
                    return redirect('/panel/transfer')->with('success', 'Bildiriminiz Onaya Gönderildi');
                } else {
                    return redirect('/panel/transfer')->with('errors', 'Bildirim Yapılamadı');
                }
            }
        }
    }


    function kirarezervasyon(Request $request)
    {
        $doviz = DB::table('kur')->pluck('oran', 'pb');

        $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
        $linkler = DB::table('linkler')->orderBy('id', 'asc')->get();
        $arac = DB::table('kiralik_arac')->where('id', $request->id)->first();
        // Formdan gelen tarih değerleri
        $alinmaTarihi = $request->input('alinma');
        $birakilmaTarihi = $request->input('birakilma');

// Carbon nesnelerini oluşturma
        $alinmaTarihi = Carbon::createFromFormat('Y-m-d', $request->alinma);
        $birakilmaTarihi = Carbon::createFromFormat('Y-m-d', $request->birakilma);

// Gün farkını hesaplama
        $gun = $birakilmaTarihi->diffInDays($alinmaTarihi) + 1;
        $durum = 'Havale Bekleniyor';
        DB::table('kiralama')->insertGetId(['userid' => auth()->user()->id, 'aracid' => $request->id, 'alinma' => $request->alinma, 'birakilma' => $request->birakilma, 'durum' => $durum, 'tarih' => date('Y-m-d H:i:s')]);
        return view('kirarezervasyon', compact('ayar', 'linkler', 'arac', 'gun', 'request','doviz'));


    }

    function sef(Request $request)
    {

        $blogs = DB::table('blog')->get();
        foreach ($blogs as $blog) {

            $slug = Str::slug($blog->baslik);
            DB::table('blog')->where('id', $blog->id)->update(['slug' => $slug]);
        }

        return redirect('/')->with('success', 'Blog slugları düzeltildi');
    }


    function map(Request $request)
    {
        $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
        $transfer = DB::table('transfer')->where('id', $request->id)->first();
        return view('map', compact('request', 'ayar', 'transfer'));
    }

    function havale(Request $request)
    {

        $tn = "";

        if ($request->tur == "transfer") {
            $durum = 'Havale Bekleniyor';
            DB::table('transfer')->where('id', $request->sorgu)->update(['durum' => "" . $durum . ""]);
        }


        $kira = 0;
        if ($request->tur == "kiralama") {
            $durum = 'Havale Bekleniyor';
            $tn = DB::table('kiralama')->where('userid', auth()->user()->id)->where('alinma', $request->alinma)->where('birakilma', $request->birakilma)->orderBy('kid', 'desc')->first();
            DB::table('kiralama')->where('kid', $tn->kid)->update(['durum' => "" . $durum . ""]);

            $kira = $this->kira($request->arac, $request->alinma, $request->birakilma);

        }


        $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
        $linkler = DB::table('linkler')->orderBy('id', 'asc')->get();
        $hesapno = DB::table('hesapno')->get();
        return view('havale', compact('request', 'ayar', 'linkler', 'hesapno', 'kira', 'tn'));
    }


    function sofor(Request $request)
    {


        $durum = 'Şöfore Ödenecek';
        DB::table('transfer')->where('id', $request->sorgu)->update(['durum' => "" . $durum . ""]);
        return redirect('/panel')->with('success', 'Rezervasyonunuz tamamlandı, Transfer sırasında ödeme talep edilecektir');

    }

    function kvkk(Request $request)
    {
        $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
        $linkler = DB::table('linkler')->orderBy('id', 'asc')->get();
        return view('kvkk', compact('request', 'ayar', 'linkler'));
    }

    function gizlilik(Request $request)
    {
        $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
        $linkler = DB::table('linkler')->orderBy('id', 'asc')->get();
        return view('kvkk', compact('request', 'ayar', 'linkler'));
    }

    function blogyazi(Request $request, $sef)
    {

        if (DB::table('blog')->where('slug', '=', $sef)->count() > 0 && $sef <> '') {

            $transkat = DB::table('transfer_kategori')->get();
            $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
            $linkler = DB::table('linkler')->orderBy('id', 'asc')->get();
            $kiralik = DB::table('kiralik_arac')->orderBy('ucret360', 'asc')->paginate(10);
            $sss = DB::table('sss')->get();
            $blog = DB::table('blog')->orderBy('id', 'desc')->where('slug', $sef)->first();
            return view('blogic', compact('request', 'ayar', 'transkat', 'linkler', 'kiralik', 'sss', 'blog'));

        } else {
            abort(404);
        }

    }

    function transfersorgula(Request $request)
    {
        $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
        $linkler = DB::table('linkler')->orderBy('id', 'asc')->get();
        $arac = DB::table('transfer_arac')->orderBy('km', 'asc')->where('aktif', 1)->where('id', $request->arac)->first();
        return view('transfersorgula', compact('request', 'ayar', 'linkler', 'arac'));
    }


    function arackirala(Request $request)
    {
        $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
        $linkler = DB::table('linkler')->orderBy('id', 'asc')->get();
        $arac = DB::table('kiralik_arac')->orderBy('ucret360', 'asc')->where('aktif', 1)->where('id', $request->arac)->first();
        return view('kiralamatarihsec', compact('request', 'ayar', 'linkler', 'arac'));
    }

    function kira($arac, $alinma, $birakilma)
    {


        $alinmaTarihi = Carbon::createFromFormat('Y-m-d', $alinma);
        $birakilmaTarihi = Carbon::createFromFormat('Y-m-d', $birakilma);

// Gün farkını hesaplama
        $gun = $birakilmaTarihi->diffInDays($alinmaTarihi) + 1;
        $arac = DB::table('kiralik_arac')->where('id', $arac)->first();
        $fiyat = 0;
        if ($gun > 180) {
            $fiyat = $arac->ucret360 * $gun;
        }
        if ($gun <= 180) {
            $fiyat = $arac->ucret180 * $gun;
        }
        if ($gun <= 30) {
            $fiyat = $arac->ucret30 * $gun;
        }
        if ($gun < 2) {
            $fiyat = $arac->ucret1 * $gun;
        }

        return $fiyat;

    }

    function arackiralahesapla(Request $request)
    {

        // Formdan gelen tarih değerleri
        $alinmaTarihi = $request->input('alinma');
        $birakilmaTarihi = $request->input('birakilma');

// Carbon nesnelerini oluşturma
        $alinmaTarihi = Carbon::createFromFormat('Y-m-d', $alinmaTarihi);
        $birakilmaTarihi = Carbon::createFromFormat('Y-m-d', $birakilmaTarihi);

// Gün farkını hesaplama
        $gun = $birakilmaTarihi->diffInDays($alinmaTarihi) + 1;

// Sonucu kullanma


        $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
        $linkler = DB::table('linkler')->orderBy('id', 'asc')->get();


        $oncelik = $request->arac;
        if ($oncelik == null) {
            $oncelik = 1;
        }

        $arac = DB::table('kiralik_arac')->orderByRaw("id = $oncelik DESC")->orderBy('ucret360', 'asc')->where('aktif', 1)->get();

        return view('kiralamafiyat', compact('request', 'ayar', 'linkler', 'arac', 'gun'));


    }


    public function yedekle()
    {
        $laravelPath = base_path();
        $backupPath = public_path('yedek.zip');
        @unlink($backupPath);

        $zip = new ZipArchive();
        if ($zip->open($backupPath, ZipArchive::CREATE | ZipArchive::OVERWRITE) === true) {
            $files = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($laravelPath), RecursiveIteratorIterator::LEAVES_ONLY);

            foreach ($files as $name => $file) {
                if (!$file->isDir()) {
                    $filePath = $file->getRealPath();
                    $relativePath = substr($filePath, strlen($laravelPath) + 1);
                    $zip->addFile($filePath, $relativePath);
                }
            }

            $zip->close();

            echo " Yedekledim";
        } else {
            return response()->json('Yedekleme işlemi başarısız oldu.');
        }
    }

    public function ac()
    {
        $publicPath = public_path();
        $backupPath = $publicPath . '/yedek.zip';
        $extractPath = dirname($publicPath);

        $zip = new ZipArchive();
        if ($zip->open($backupPath) === true) {
            $zip->extractTo($extractPath);
            $zip->close();

            File::delete(public_path('yedek.zip'));

            return redirect('/');

        } else {
            echo "Olmadı";
        }
    }


//    function demo(Request$request)
//    {
//
//        auth()->logout();
//        DB::table('users')->where('email','demo@demo.com')->delete();
//        $id=DB::table('users')->insertGetId(['name'=>'Demo Müşteri','email'=>rand(1,9999)."@".rand(1,9999).".com",'password'=>"123123",'telefon'=>rand(111111111111,999999999999),'rol'=>'musteri']);
//
//        auth()->loginUsingId($id);
//        return redirect('/');
//
//    }function demoadmin(Request$request)
//    {
//
//        auth()->logout();
//        DB::table('users')->where('email','demo@demo.com')->delete();
//        $id=DB::table('users')->insertGetId(['name'=>'Demo Müşteri','email'=>rand(1,9999)."@".rand(1,9999).".com",'password'=>"123123",'telefon'=>rand(111111111111,999999999999),'rol'=>'admin']);
//
//        auth()->loginUsingId($id);
//        return redirect('/admin');
//
//    }


    function turlar(Request $request,$kat="")
    {
        DB::table('turlar')
            ->update(['price' => DB::raw('yetiskin')]);

        $sayfa=36;
        if (isset($request->sayfa))
        {
            $sayfa=$request->sayfa;
        }



        $slug=DB::table('turkat')->where('slug',null)->get();
        foreach ($slug as $item)
        {
            DB::table('turkat')->where('id',$item->id)->update(['slug'=>Str::slug($item->turkat)]);
        }

        $slug=DB::table('turlar')->where('turslug',null)->get();
        foreach ($slug as $item)
        {
            DB::table('turlar')->where('id',$item->id)->update(['turslug'=>Str::slug($item->baslik)]);
        }

        $turkat=DB::table('turkat')->orderBy('id','asc')->get();

        $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
        $linkler = DB::table('linkler')->orderBy('id', 'asc')->get();



        $sorgu=DB::table('turlar')->join('turkat','turlar.katid','turkat.id');

        if ($kat<>"")
        {
            $sorgu->where('slug',$kat);
        }

            $sorgu->orderBy('turlar.id','desc');


        $turlar=$sorgu->paginate($sayfa);

        $doviz = DB::table('kur')->pluck('oran', 'pb');


        return view('turlar',compact('request','ayar','linkler','turkat','turlar','doviz'));
    }

    function tur(Request$request, $turslug)
    {


        $tur = DB::table('turlar')
            ->join('turkat', 'turlar.katid', '=', 'turkat.id')
            ->select('turlar.id as turlar_id', 'turlar.*', 'turkat.*')
            ->where('turslug',$turslug)->first();





        $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
        $linkler = DB::table('linkler')->orderBy('id', 'asc')->get();
        $doviz = DB::table('kur')->pluck('oran', 'pb');
        return view('tur',compact('request','ayar','linkler','tur','doviz'));
    }

      function kur()
    {
        // API URL to get exchange rates
        $apiUrl = 'https://api.exchangerate-api.com/v4/latest/TRY';

        // Initialize Guzzle HTTP client
        $client = new \GuzzleHttp\Client();

        try {
            // Send a GET request to the API
            $response = $client->get($apiUrl);

            // Decode the JSON response
            $data = json_decode($response->getBody(), true);

            // Get the exchange rates for all possible currencies
            $exchangeRates = $data['rates'] ?? [];

            if (count($exchangeRates)>0) {
                DB::table('kur')->truncate();
            }
            // Pass the exchange rates to the view
            foreach ($exchangeRates as $currency => $rate) {
                // Store the exchange rate in the database using Query Builder
                DB::table('kur')->insert([
                    'pb' => $currency,
                    'oran' => 1/$rate,
                    'tarih' => now(),

                ]);
            }

        } catch (\Exception $e) {
            die('Kurlar Alınamıyor <br>'.$e->getMessage());
        }
    }

    function parabirimi(Request $request)
    {
        $parabirimleri = DB::table('kur')
            ->orderByRaw("
                    CASE pb
                        WHEN 'EUR' THEN 1
                        WHEN 'TRY' THEN 1
                        WHEN 'USD' THEN 2
                        WHEN 'AED' THEN 3
                        WHEN 'RUB' THEN 4
                        WHEN 'JPY' THEN 5
                        WHEN 'CNY' THEN 6
                        ELSE 7
                    END,
                    pb,
                    oran DESC
                ")
            ->limit(20)
            ->get();

        return view('pbselect',compact('parabirimleri','request'));

    }

    function parabirimiup(Request $request)
    {
        session()->put('pb',$request->pb);
        if (auth()->check())
        {
            DB::table('users')->where('id',auth()->user()->id)->update(['pb'=>$request->pb]);

        }

        return redirect()->back()->with('success',$request->pb." olarak parabirimi güncellendi");
    }


    function turkayit(Request $request)
    {
        $tur=DB::table('turlar')->where('id',$request->turid)->first();


        $toplam=($tur->yetiskin*$request->yetiskin);
        $toplam+=($tur->bcocuk*$request->bcocuk);
        $toplam+=($tur->kcocuk*$request->kcocuk);
        $toplam+=($tur->bebek*$request->bebek);

        $sip=DB::table('tursip')->insertGetId([
            'userid'=>auth()->id(),
            'turid'=>$request->turid,
            'yetiskin'=>$request->yetiskin,
            'bcocuk'=>$request->bcocuk,
            'kcocuk'=>$request->kcocuk,
            'bebek'=>$request->bebek,
            'turtarih'=>$request->turtarih,
            'toplam'=>$toplam,
            'gosterilen'=>number_format($request->gosterilen,2)." ".session()->get('pb'),
            'siptarih'=>now()

        ]);


        $ayar = DB::table('ayar')->pluck('deger', 'anahtar');
        $doviz = DB::table('kur')->pluck('oran', 'pb');


        if (session()->get('pb')==$ayar['pb'])
        {
            $toplam=$toplam*$doviz[$ayar['pb']];
        }
        else
        {
            $toplam=$toplam/$doviz[session()->get('pb')]*$doviz[$ayar['pb']];
        }







                return redirect('/paytr?tip=tur&turid='.$sip.'&miktar='.$toplam);





    }


}

